#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "Gamma Fit of GC2 C11+ MWs"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    145.04      147.43      148.67     9.9312e-02    9.9312e-02    5.3149e-02    5.3599e-02
    153.46      160.16      158.92     8.8496e-02    8.8496e-02    5.1453e-02    5.1054e-02
    164.85      172.81      171.37     8.5054e-02    8.5054e-02    5.3356e-02    5.2914e-02
    178.30      185.36      184.40     6.7847e-02    6.7847e-02    4.5652e-02    4.5416e-02
    190.77      197.81      197.58     6.6863e-02    6.6863e-02    4.8012e-02    4.7958e-02
    204.68      210.15      211.27     5.7522e-02    5.7522e-02    4.3883e-02    4.4116e-02
    218.09      222.40      223.87     4.5723e-02    4.5723e-02    3.6914e-02    3.7158e-02
    229.82      234.55      236.05     4.5231e-02    4.5231e-02    3.8512e-02    3.8758e-02
    242.46      246.59      248.74     4.1790e-02    4.1790e-02    3.7408e-02    3.7734e-02
    255.19      258.53      260.71     3.3923e-02    3.3923e-02    3.1837e-02    3.2105e-02
    266.35      270.37      270.97     2.6549e-02    2.6549e-02    2.6057e-02    2.6115e-02
    275.67      282.11      281.31     3.0482e-02    3.0482e-02    3.1217e-02    3.1127e-02
    287.07      293.76      292.02     2.5074e-02    2.5074e-02    2.6738e-02    2.6580e-02
    297.07      305.30      302.96     2.8024e-02    2.8024e-02    3.1058e-02    3.0820e-02
    308.99      316.75      314.41     2.4090e-02    2.4090e-02    2.7701e-02    2.7495e-02
    319.94      328.11      325.47     2.3107e-02    2.3107e-02    2.7523e-02    2.7301e-02
    331.12      339.38      336.76     2.2124e-02    2.2124e-02    2.7257e-02    2.7046e-02
    342.52      350.56      348.82     2.3107e-02    2.3107e-02    2.9406e-02    2.9260e-02
    355.26      361.66      361.14     2.0157e-02    2.0157e-02    2.6464e-02    2.6426e-02
    367.14      580.00      575.49     1.4553e-01    3.2814e-01    3.0640e-01    6.8553e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_001_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_001_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_001_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_001_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "EOS Fluid Characterization \"13-Component\""
show title

$Expt << END
#                                          Tc          Pc                                   Tb                                              Visc
# Component       LMW          MW         (R)        (psia)        AF         VTran         (F)          SG          Zc        ZcVis        (cp)
#-----------   ---------   ---------   ---------   ---------   ---------   ----------   ----------   ---------   ---------   ---------   ----------
   CO2              NaN      44.010      547.42     1069.51     0.22500      0.00191     -126.879     0.76193     0.27433     0.27433          NaN
   C1N2             NaN      16.094      342.48      666.29     0.01110     -0.15003     -259.146     0.14662     0.28622     0.28622          NaN
   C2               NaN      30.070      549.58      706.62     0.09900     -0.06280     -127.690     0.32976     0.27924     0.27924          NaN
   C3               NaN      44.097      665.69      616.12     0.15200     -0.06381      -43.989     0.50977     0.27630     0.27630          NaN
   C4            51.110      58.123      757.33      544.82     0.19644     -0.05597       25.973     0.58564     0.27592     0.27592          NaN
   C5            63.908      72.150      838.87      489.45     0.24286     -0.03996       91.325     0.63338     0.26992     0.26992          NaN
   C6-C7         75.540      88.738      959.66      482.36     0.25014     -0.00108      172.819     0.72783     0.26883     0.26883          NaN
   C8-C9        101.890     114.038     1047.18      446.47     0.29339     -0.06336      243.509     0.77421     0.26022     0.28129      0.24320
   C10-C13      128.136     151.788     1149.12      390.33     0.36733     -0.10576      335.182     0.81267     0.24920     0.29490      0.41750
   C14-C19      179.069     212.240     1270.85      326.90     0.48011     -0.14670      453.198     0.85067     0.23517     0.31411      0.86320
   C20-C29      252.543     306.193     1426.84      249.89     0.66872     -0.09879      620.657     0.88845     0.21626     0.31490      2.11113
   C30-C44      367.144     435.151     1574.24      194.80     0.89686     -0.07736      787.995     0.92269     0.19548     0.32351      5.44552
   C45+         524.117     737.351     1784.78      144.77     1.27407     -0.15125     1028.420     0.97421     0.16209     0.37004     24.12613
END
set xlabel "Molecular Weight"
set ylabel "Critical Temperature (R)"
set output "Figures/Table_003_TC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:4 with points notitle
set ylabel "Critical Pressure (psia)"
set output "Figures/Table_003_PC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:5 with points notitle
set ylabel "Acentric Factor"
set output "Figures/Table_003_AF_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:6 with points notitle
set ylabel "Volume Translation"
set output "Figures/Table_003_VT_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:7 with points notitle
set ylabel "Boiling Temperature (F)"
set output "Figures/Table_003_TB_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:8 with points notitle
set ylabel "Specific Gravity"
set output "Figures/Table_003_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:9 with points notitle
set ylabel "Viscosity Z-Factor"
set output "Figures/Table_003_VISZ_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:11 with points notitle
set ylabel "Liquid Viscosity (cp)"
set output "Figures/Table_003_LVIS_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:12 with points notitle

set title "Phase Envelope for Oil Sample 1"
show title

$Env_DP << END
#    Temp         Sat Pres                                                                                     Liq Den       Gas Den             
#    (C)           (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#-----------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   42.88283     1.00000e-13        0.00000         2.89449e-15          1.00000       737.351     99.0686     0.969473     3.77024e-16     6.92631e-18
   45.00000     1.54334e-13        0.00000         4.43885e-15          1.00000       737.351     99.0686     0.969167     5.78003e-16     1.05839e-17
   47.50000     2.55430e-13        0.00000         7.29198e-15          1.00000       737.351     99.0686     0.968802     9.49166e-16     1.73174e-17
   50.00000     4.18930e-13        0.00000         1.18715e-14          1.00000       737.351     99.0686     0.968435     1.54468e-15     2.80873e-17
   52.50000     6.81028e-13        0.00000         1.91580e-14          1.00000       737.351     99.0686     0.968065     2.49181e-15     4.51667e-17
   55.00000     1.09758e-12        0.00000         3.06527e-14          1.00000       737.351     99.0686     0.967691     3.98535e-15     7.20280e-17
   57.50000     1.75408e-12        0.00000         4.86355e-14          1.00000       737.351     99.0686     0.967315     6.32096e-15     1.13932e-16
   60.00000     2.78028e-12        0.00000         7.65406e-14          1.00000       737.351     99.0686     0.966935     9.94376e-15     1.78786e-16
   62.50000     4.37160e-12        0.00000         1.19500e-13          1.00000       737.351     99.0686     0.966552     1.55187e-14     2.78390e-16
   65.00000     6.82004e-12        0.00000         1.85125e-13          1.00000       737.351     99.0686     0.966166     2.40314e-14     4.30210e-16
   67.50000     1.05587e-11        0.00000         2.84618e-13          1.00000       737.351     99.0686     0.965777     3.69319e-14     6.59924e-16
   70.00000     1.62249e-11        0.00000         4.34348e-13          1.00000       737.351     99.0686     0.965385     5.63379e-14     1.00501e-15
   72.50000     2.47506e-11        0.00000         6.58060e-13          1.00000       737.351     99.0686     0.964990     8.53199e-14     1.51977e-15
   75.00000     3.74877e-11        0.00000         9.89962e-13          1.00000       737.351     99.0686     0.964591     1.28299e-13     2.28240e-15
   77.50000     5.63850e-11        0.00000         1.47900e-12          1.00000       737.351     99.0686     0.964189     1.91598e-13     3.40469e-15
   80.00000     8.42324e-11        0.00000         2.19473e-12          1.00000       737.351     99.0686     0.963784     2.84198e-13     5.04551e-15
   82.50000     1.24998e-10        0.00000         3.23537e-12          1.00000       737.351     99.0686     0.963375     4.18776e-13     7.42911e-15
   85.00000     1.84288e-10        0.00000         4.73874e-12          1.00000       737.350     99.0686     0.962963     6.13105e-13     1.08702e-14
   87.50000     2.69978e-10        0.00000         6.89700e-12          1.00000       737.350     99.0686     0.962548     8.91958e-13     1.58075e-14
   90.00000     3.93057e-10        0.00000         9.97645e-12          1.00000       737.350     99.0686     0.962129     1.28965e-12     2.28496e-14
   92.50000     5.68773e-10        0.00000         1.43440e-11          1.00000       737.350     99.0686     0.961707     1.85342e-12     3.28352e-14
   95.00000     8.18154e-10        0.00000         2.05021e-11          1.00000       737.350     99.0686     0.961282     2.64796e-12     4.69138e-14
   97.50000     1.17004e-09        0.00000         2.91353e-11          1.00000       737.350     99.0686     0.960853     3.76130e-12     6.66525e-14
  100.00000     1.66376e-09        0.00000         4.11704e-11          1.00000       737.350     99.0686     0.960420     5.31262e-12     9.41762e-14
  102.50000     2.35265e-09        0.00000         5.78562e-11          1.00000       737.349     99.0686     0.959984     7.46236e-12     1.32350e-13
  105.00000     3.30867e-09        0.00000         8.08655e-11          1.00000       737.349     99.0686     0.959544     1.04254e-11     1.85020e-13
  107.50000     4.62837e-09        0.00000         1.12429e-10          1.00000       737.349     99.0686     0.959101     1.44878e-11     2.57317e-13
  110.00000     6.44065e-09        0.00000         1.55503e-10          1.00000       737.349     99.0686     0.958654     2.00292e-11     3.56062e-13
  112.50000     8.91676e-09        0.00000         2.13991e-10          1.00000       737.348     99.0686     0.958203     2.75496e-11     4.90267e-13
  115.00000     1.22830e-08        0.00000         2.93017e-10          1.00000       737.348     99.0686     0.957748     3.77057e-11     6.71793e-13
  117.50000     1.68372e-08        0.00000         3.99279e-10          1.00000       737.347     99.0686     0.957290     5.13551e-11     9.16173e-13
  120.00000     2.29691e-08        0.00000         5.41488e-10          1.00000       737.347     99.0686     0.956828     6.96125e-11     1.24366e-12
  122.50000     3.11868e-08        0.00000         7.30927e-10          1.00000       737.346     99.0686     0.956362     9.39206e-11     1.68054e-12
  125.00000     4.21493e-08        0.00000         9.82136e-10          1.00000       737.346     99.0686     0.955893     1.26138e-10     2.26078e-12
  127.50000     5.67081e-08        0.00000         1.31378e-09          1.00000       737.345     99.0686     0.955419     1.68648e-10     3.02810e-12
  130.00000     7.59580e-08        0.00000         1.74971e-09          1.00000       737.344     99.0686     0.954942     2.24496e-10     4.03852e-12
  132.50000     1.01301e-07        0.00000         2.32028e-09          1.00000       737.343     99.0686     0.954460     2.97553e-10     5.36354e-12
  135.00000     1.34525e-07        0.00000         3.06395e-09          1.00000       737.342     99.0686     0.953975     3.92722e-10     7.09406e-12
  137.50000     1.77901e-07        0.00000         4.02927e-09          1.00000       737.341     99.0686     0.953486     5.16188e-10     9.34517e-12
  140.00000     2.34301e-07        0.00000         5.27729e-09          1.00000       737.339     99.0686     0.952992     6.75723e-10     1.22620e-11
  142.50000     3.07345e-07        0.00000         6.88444e-09          1.00000       737.338     99.0686     0.952495     8.81049e-10     1.60271e-11
  145.00000     4.01576e-07        0.00000         8.94609e-09          1.00000       737.336     99.0686     0.951993     1.14429e-09     2.08688e-11
  147.50000     5.22674e-07        0.00000         1.15808e-08          1.00000       737.335     99.0686     0.951487     1.48051e-09     2.70720e-11
  150.00000     6.77717e-07        0.00000         1.49353e-08          1.00000       737.333     99.0686     0.950977     1.90834e-09     3.49909e-11
  152.50000     8.75490e-07        0.00000         1.91907e-08          1.00000       737.330     99.0686     0.950462     2.45076e-09     4.50643e-11
  155.00000     1.12686e-06        0.00000         2.45699e-08          1.00000       737.328     99.0686     0.949943     3.13600e-09     5.78340e-11
  157.50000     1.44522e-06        0.00000         3.13456e-08          1.00000       737.325     99.0686     0.949420     3.99864e-09     7.39664e-11
  160.00000     1.84703e-06        0.00000         3.98513e-08          1.00000       737.322     99.0686     0.948893     5.08087e-09     9.42790e-11
  162.50000     2.35243e-06        0.00000         5.04925e-08          1.00000       737.319     99.0686     0.948361     6.43400e-09     1.19771e-10
  165.00000     2.98600e-06        0.00000         6.37615e-08          1.00000       737.316     99.0686     0.947824     8.12024e-09     1.51661e-10
  167.50000     3.77764e-06        0.00000         8.02535e-08          1.00000       737.312     99.0686     0.947284     1.02148e-08     1.91427e-10
  170.00000     4.76361e-06        0.00000         1.00686e-07          1.00000       737.307     99.0686     0.946738     1.28082e-08     2.40863e-10
  172.50000     5.98770e-06        0.00000         1.25922e-07          1.00000       737.303     99.0686     0.946188     1.60091e-08     3.02132e-10
  175.00000     7.50273e-06        0.00000         1.56994e-07          1.00000       737.298     99.0686     0.945633     1.99479e-08     3.77839e-10
  177.50000     9.37212e-06        0.00000         1.95136e-07          1.00000       737.292     99.0686     0.945073     2.47799e-08     4.71115e-10
  180.00000     1.16719e-05        0.00000         2.41821e-07          1.00000       737.286     99.0686     0.944509     3.06902e-08     5.85704e-10
  182.50000     1.44927e-05        0.00000         2.98793e-07          1.00000       737.279     99.0686     0.943940     3.78982e-08     7.26079e-10
  185.00000     1.79426e-05        0.00000         3.68122e-07          1.00000       737.272     99.0686     0.943366     4.66638e-08     8.97566e-10
  187.50000     2.21501e-05        0.00000         4.52252e-07          1.00000       737.264     99.0686     0.942787     5.72937e-08     1.10649e-09
  190.00000     2.72671e-05        0.00000         5.54060e-07          1.00000       737.255     99.0686     0.942203     7.01487e-08     1.36034e-09
  192.50000     3.34732e-05        0.00000         6.76930e-07          1.00000       737.246     99.0686     0.941614     8.56525e-08     1.66798e-09
  195.00000     4.09800e-05        0.00000         8.24823e-07          1.00000       737.236     99.0686     0.941019     1.04301e-07     2.03982e-09
  197.50000     5.00360e-05        0.00000         1.00237e-06          1.00000       737.225     99.0686     0.940420     1.26674e-07     2.48814e-09
  200.00000     6.09324e-05        0.00000         1.21497e-06          1.00000       737.213     99.0686     0.939815     1.53445e-07     3.02732e-09
  202.50000     7.40100e-05        0.00000         1.46890e-06          1.00000       737.200     99.0686     0.939206     1.85398e-07     3.67417e-09
  205.00000     8.96658e-05        0.00000         1.77145e-06          1.00000       737.186     99.0686     0.938590     2.23442e-07     4.44835e-09
  207.50000     1.08362e-04        0.00000         2.13105e-06          1.00000       737.171     99.0686     0.937970     2.68627e-07     5.37272e-09
  210.00000     1.30635e-04        0.00000         2.55742e-06          1.00000       737.155     99.0686     0.937343     3.22165e-07     6.47386e-09
  212.50000     1.57104e-04        0.00000         3.06177e-06          1.00000       737.137     99.0686     0.936712     3.85449e-07     7.78258e-09
  215.00000     1.88489e-04        0.00000         3.65700e-06          1.00000       737.118     99.0686     0.936074     4.60081e-07     9.33451e-09
  217.50000     2.25614e-04        0.00000         4.35786e-06          1.00000       737.098     99.0686     0.935431     5.47895e-07     1.11708e-08
  220.00000     2.69431e-04        0.00000         5.18126e-06          1.00000       737.076     99.0686     0.934783     6.50985e-07     1.33388e-08
  222.50000     3.21030e-04        0.00000         6.14649e-06          1.00000       737.052     99.0686     0.934128     7.71744e-07     1.58931e-08
  225.00000     3.81659e-04        0.00000         7.27554e-06          1.00000       737.027     99.0686     0.933467     9.12891e-07     1.88961e-08
  227.50000     4.52746e-04        0.00000         8.59338e-06          1.00000       736.999     99.0686     0.932801     1.07752e-06     2.24195e-08
  230.00000     5.35916e-04        0.00000         1.01284e-05          0.99999       736.970     99.0686     0.932128     1.26912e-06     2.65448e-08
  232.50000     6.33021e-04        0.00000         1.19126e-05          0.99999       736.938     99.0686     0.931449     1.49167e-06     3.13656e-08
  235.00000     7.46161e-04        0.00000         1.39823e-05          0.99999       736.904     99.0686     0.930764     1.74963e-06     3.69878e-08
  237.50000     8.77717e-04        0.00000         1.63784e-05          0.99999       736.868     99.0686     0.930072     2.04803e-06     4.35322e-08
  240.00000     1.03038e-03        0.00000         1.91468e-05          0.99999       736.829     99.0686     0.929374     2.39255e-06     5.11356e-08
  242.50000     1.20720e-03        0.00000         2.23393e-05          0.99999       736.788     99.0686     0.928670     2.78952e-06     5.99529e-08
  245.00000     1.41158e-03        0.00000         2.60139e-05          0.99999       736.743     99.0686     0.927958     3.24608e-06     7.01591e-08
  247.50000     1.64740e-03        0.00000         3.02353e-05          0.99998       736.696     99.0686     0.927240     3.77017e-06     8.19519e-08
  250.00000     1.91895e-03        0.00000         3.50760e-05          0.99998       736.645     99.0686     0.926515     4.37067e-06     9.55537e-08
  252.50000     2.23110e-03        0.00000         4.06167e-05          0.99998       736.591     99.0686     0.925784     5.05747e-06     1.11215e-07
  255.00000     2.58925e-03        0.00000         4.69475e-05          0.99998       736.533     99.0686     0.925045     5.84156e-06     1.29216e-07
  257.50000     2.99946e-03        0.00000         5.41681e-05          0.99997       736.471     99.0686     0.924299     6.73516e-06     1.49872e-07
  260.00000     3.46845e-03        0.00000         6.23894e-05          0.99997       736.406     99.0686     0.923545     7.75178e-06     1.73535e-07
  262.50000     4.00374e-03        0.00000         7.17341e-05          0.99997       736.335     99.0686     0.922784     8.90638e-06     2.00598e-07
  265.00000     4.61364e-03        0.00000         8.23378e-05          0.99996       736.261     99.0686     0.922016     1.02155e-05     2.31502e-07
  267.50000     5.30740e-03        0.00000         9.43503e-05          0.99996       736.181     99.0686     0.921240     1.16973e-05     2.66736e-07
  270.00000     6.09523e-03        0.00000         1.07936e-04          0.99995       736.097     99.0686     0.920456     1.33719e-05     3.06843e-07
  272.50000     6.98845e-03        0.00000         1.23278e-04          0.99994       736.007     99.0686     0.919664     1.52614e-05     3.52428e-07
  275.00000     7.99953e-03        0.00000         1.40574e-04          0.99994       735.911     99.0686     0.918864     1.73898e-05     4.04162e-07
  277.50000     9.14220e-03        0.00000         1.60043e-04          0.99993       735.809     99.0686     0.918056     1.97837e-05     4.62789e-07
  280.00000     1.04316e-02        0.00000         1.81925e-04          0.99992       735.702     99.0686     0.917239     2.24722e-05     5.29130e-07
  282.50000     1.18843e-02        0.00000         2.06482e-04          0.99991       735.587     99.0686     0.916414     2.54868e-05     6.04094e-07
  285.00000     1.35186e-02        0.00000         2.33999e-04          0.99990       735.465     99.0686     0.915579     2.88621e-05     6.88683e-07
  287.50000     1.53545e-02        0.00000         2.64789e-04          0.99989       735.337     99.0686     0.914736     3.26358e-05     7.84003e-07
  290.00000     1.74137e-02        0.00000         2.99190e-04          0.99987       735.200     99.0686     0.913884     3.68488e-05     8.91270e-07
  292.50000     1.97201e-02        0.00000         3.37572e-04          0.99986       735.055     99.0686     0.913023     4.15456e-05     1.01182e-06
  295.00000     2.22998e-02        0.00000         3.80335e-04          0.99984       734.902     99.0686     0.912152     4.67745e-05     1.14713e-06
  297.50000     2.51812e-02        0.00000         4.27915e-04          0.99983       734.739     99.0686     0.911271     5.25876e-05     1.29880e-06
  300.00000     2.83950e-02        0.00000         4.80781e-04          0.99981       734.568     99.0686     0.910381     5.90418e-05     1.46861e-06
  302.50000     3.19748e-02        0.00000         5.39443e-04          0.99978       734.386     99.0686     0.909480     6.61979e-05     1.65848e-06
  305.00000     3.59570e-02        0.00000         6.04451e-04          0.99976       734.193     99.0686     0.908569     7.41222e-05     1.87053e-06
  307.50000     4.03810e-02        0.00000         6.76397e-04          0.99974       733.990     99.0686     0.907648     8.28856e-05     2.10709e-06
  310.00000     4.52896e-02        0.00000         7.55921e-04          0.99971       733.775     99.0686     0.906715     9.25650e-05     2.37066e-06
  312.50000     5.07290e-02        0.00000         8.43711e-04          0.99968       733.549     99.0686     0.905772     1.03243e-04     2.66400e-06
  315.00000     5.67490e-02        0.00000         9.40507e-04          0.99965       733.309     99.0686     0.904817     1.15007e-04     2.99012e-06
  317.50000     6.34035e-02        0.00000         1.04710e-03          0.99961       733.056     99.0686     0.903851     1.27954e-04     3.35228e-06
  320.00000     7.07505e-02        0.00000         1.16435e-03          0.99957       732.789     99.0686     0.902873     1.42184e-04     3.75403e-06
  322.50000     7.88525e-02        0.00000         1.29316e-03          0.99953       732.508     99.0686     0.901883     1.57808e-04     4.19925e-06
  325.00000     8.77767e-02        0.00000         1.43451e-03          0.99949       732.211     99.0686     0.900880     1.74942e-04     4.69213e-06
  327.50000     9.75955e-02        0.00000         1.58945e-03          0.99944       731.898     99.0686     0.899865     1.93711e-04     5.23723e-06
  330.00000     1.08386e-01        0.00000         1.75910e-03          0.99938       731.569     99.0686     0.898836     2.14249e-04     5.83950e-06
  332.50000     1.20232e-01        0.00000         1.94463e-03          0.99933       731.222     99.0686     0.897794     2.36698e-04     6.50431e-06
  335.00000     1.33223e-01        0.00000         2.14734e-03          0.99927       730.856     99.0686     0.896739     2.61210e-04     7.23748e-06
  337.50000     1.47454e-01        0.00000         2.36856e-03          0.99920       730.471     99.0686     0.895669     2.87947e-04     8.04532e-06
  340.00000     1.63027e-01        0.00000         2.60975e-03          0.99913       730.066     99.0686     0.894584     3.17082e-04     8.93464e-06
  342.50000     1.80051e-01        0.00000         2.87243e-03          0.99905       729.639     99.0686     0.893485     3.48799e-04     9.91283e-06
  345.00000     1.98644e-01        0.00000         3.15823e-03          0.99897       729.191     99.0686     0.892371     3.83292e-04     1.09879e-05
  347.50000     2.18930e-01        0.00000         3.46888e-03          0.99888       728.719     99.0686     0.891240     4.20770e-04     1.21685e-05
  350.00000     2.41042e-01        0.00000         3.80623e-03          0.99879       728.223     99.0686     0.890093     4.61453e-04     1.34640e-05
  352.50000     2.65122e-01        0.00000         4.17221e-03          0.99869       727.702     99.0686     0.888930     5.05575e-04     1.48845e-05
  355.00000     2.91322e-01        0.00000         4.56890e-03          0.99858       727.154     99.0686     0.887750     5.53385e-04     1.64410e-05
  357.50000     3.19803e-01        0.00000         4.99848e-03          0.99847       726.579     99.0686     0.886551     6.05147e-04     1.81452e-05
  360.00000     3.50736e-01        0.00000         5.46327e-03          0.99835       725.974     99.0686     0.885335     6.61140e-04     2.00100e-05
  362.50000     3.84304e-01        0.00000         5.96572e-03          0.99822       725.340     99.0686     0.884100     7.21662e-04     2.20493e-05
  365.00000     4.20702e-01        0.00000         6.50842e-03          0.99808       724.673     99.0686     0.882845     7.87026e-04     2.42779e-05
  367.50000     4.60137e-01        0.00000         7.09411e-03          0.99793       723.974     99.0686     0.881570     8.57567e-04     2.67120e-05
  370.00000     5.02829e-01        0.00000         7.72570e-03          0.99777       723.239     99.0686     0.880275     9.33638e-04     2.93691e-05
  372.50000     5.49013e-01        0.00000         8.40625e-03          0.99761       722.469     99.0686     0.878958     1.01561e-03     3.22682e-05
  375.00000     5.98937e-01        0.00000         9.13899e-03          0.99743       721.661     99.0686     0.877620     1.10389e-03     3.54297e-05
  377.50000     6.52866e-01        0.00000         9.92735e-03          0.99724       720.813     99.0686     0.876258     1.19889e-03     3.88759e-05
  380.00000     7.11083e-01        0.00000         1.07749e-02          0.99704       719.923     99.0686     0.874873     1.30106e-03     4.26306e-05
  382.50000     7.73885e-01        0.00000         1.16855e-02          0.99683       718.991     99.0686     0.873463     1.41086e-03     4.67200e-05
  385.00000     8.41593e-01        0.00000         1.26632e-02          0.99661       718.013     99.0686     0.872028     1.52882e-03     5.11722e-05
  387.50000     9.14545e-01        0.00000         1.37122e-02          0.99637       716.987     99.0686     0.870567     1.65545e-03     5.60180e-05
  390.00000     9.93101e-01        0.00000         1.48371e-02          0.99612       715.912     99.0686     0.869079     1.79132e-03     6.12904e-05
  392.50000     1.07765e+00        0.00000         1.60424e-02          0.99586       714.785     99.0686     0.867563     1.93703e-03     6.70258e-05
  395.00000     1.16859e+00        0.00000         1.73334e-02          0.99558       713.603     99.0686     0.866017     2.09322e-03     7.32634e-05
  397.50000     1.26636e+00        0.00000         1.87152e-02          0.99528       712.364     99.0686     0.864441     2.26057e-03     8.00459e-05
  400.00000     1.37144e+00        0.00000         2.01936e-02          0.99497       711.066     99.0686     0.862833     2.43981e-03     8.74202e-05
  402.50000     1.48431e+00        0.00000         2.17743e-02          0.99464       709.704     99.0686     0.861192     2.63170e-03     9.54369e-05
  405.00000     1.60550e+00        0.00000         2.34638e-02          0.99430       708.277     99.0686     0.859517     2.83706e-03     1.04152e-04
  407.50000     1.73557e+00        0.00000         2.52686e-02          0.99394       706.781     99.0686     0.857806     3.05677e-03     1.13626e-04
  410.00000     1.87515e+00        0.00000         2.71958e-02          0.99355       705.213     99.0686     0.856058     3.29177e-03     1.23925e-04
  412.50000     2.02486e+00        0.00000         2.92530e-02          0.99315       703.569     99.0686     0.854270     3.54307e-03     1.35124e-04
  415.00000     2.18542e+00        0.00000         3.14480e-02          0.99273       701.844     99.0686     0.852442     3.81173e-03     1.47302e-04
  417.50000     2.35755e+00        0.00000         3.37893e-02          0.99228       700.036     99.0686     0.850572     4.09892e-03     1.60547e-04
  420.00000     2.54208e+00        0.00000         3.62859e-02          0.99181       698.139     99.0686     0.848656     4.40588e-03     1.74958e-04
  422.50000     2.73985e+00        0.00000         3.89473e-02          0.99132       696.148     99.0686     0.846694     4.73394e-03     1.90642e-04
  425.00000     2.95182e+00        0.00000         4.17840e-02          0.99081       694.060     99.0686     0.844682     5.08456e-03     2.07719e-04
  427.50000     3.17897e+00        0.00000         4.48067e-02          0.99026       691.867     99.0686     0.842619     5.45929e-03     2.26322e-04
  430.00000     3.42241e+00        0.00000         4.80273e-02          0.98970       689.565     99.0686     0.840500     5.85983e-03     2.46598e-04
  432.50000     3.68333e+00        0.00000         5.14582e-02          0.98910       687.148     99.0686     0.838325     6.28802e-03     2.68713e-04
  435.00000     3.96301e+00        0.00000         5.51132e-02          0.98847       684.607     99.0686     0.836088     6.74588e-03     2.92851e-04
  437.50000     4.26287e+00        0.00000         5.90067e-02          0.98781       681.936     99.0686     0.833787     7.23561e-03     3.19220e-04
  440.00000     4.58446e+00        0.00000         6.31546e-02          0.98712       679.127     99.0686     0.831417     7.75961e-03     3.48053e-04
  442.50000     4.92946e+00        0.00000         6.75740e-02          0.98639       676.171     99.0686     0.828975     8.32053e-03     3.79615e-04
  445.00000     5.29974e+00        0.00000         7.22835e-02          0.98563       673.059     99.0686     0.826455     8.92130e-03     4.14205e-04
  447.50000     5.69738e+00        0.00000         7.73035e-02          0.98483       669.779     99.0686     0.823853     9.56518e-03     4.52166e-04
  450.00000     6.12468e+00        0.00000         8.26562e-02          0.98398       666.320     99.0686     0.821162     1.02558e-02     4.93890e-04
  452.50000     6.58420e+00        0.00000         8.83662e-02          0.98310       662.670     99.0686     0.818375     1.09972e-02     5.39827e-04
  455.00000     7.07881e+00        0.00000         9.44606e-02          0.98217       658.813     99.0686     0.815487     1.17939e-02     5.90500e-04
  457.50000     7.61177e+00        0.00000         1.00970e-01          0.98119       654.733     99.0686     0.812487     1.26510e-02     6.46516e-04
  460.00000     8.18677e+00        0.00000         1.07927e-01          0.98016       650.413     99.0686     0.809368     1.35746e-02     7.08588e-04
  462.50000     8.80801e+00        0.00000         1.15370e-01          0.97907       645.832     99.0686     0.806117     1.45712e-02     7.77557e-04
  465.00000     9.48034e+00        0.00000         1.23343e-01          0.97792       640.966     99.0686     0.802723     1.56487e-02     8.54426e-04
  467.50000     1.02094e+01        0.00000         1.31894e-01          0.97671       635.787     99.0686     0.799170     1.68161e-02     9.40397e-04
  470.00000     1.10019e+01        0.00000         1.41081e-01          0.97542       630.264     99.0686     0.795443     1.80841e-02     1.03693e-03
  472.50000     1.18655e+01        0.00000         1.50970e-01          0.97406       624.360     99.0686     0.791520     1.94655e-02     1.14583e-03
  475.00000     1.28098e+01        0.00000         1.61639e-01          0.97262       618.030     99.0686     0.787377     2.09755e-02     1.26932e-03
  477.50000     1.38463e+01        0.00000         1.73184e-01          0.97108       611.220     99.0686     0.782984     2.26331e-02     1.41023e-03
  480.00000     1.49893e+01        0.00000         1.85718e-01          0.96943       603.863     99.0686     0.778304     2.44615e-02     1.57221e-03
  482.50000     1.62569e+01        0.00000         1.99387e-01          0.96767       595.877     99.0686     0.773290     2.64907e-02     1.76006e-03
  485.00000     1.76728e+01        0.00000         2.14375e-01          0.96576       587.153     99.0686     0.767880     2.87596e-02     1.98026e-03
  487.50000     1.92687e+01        0.00000         2.30925e-01          0.96369       577.547     99.0686     0.761991     3.13209e-02     2.24190e-03
  490.00000     2.10892e+01        0.00000         2.49376e-01          0.96142       566.861     99.0686     0.755507     3.42484e-02     2.55820e-03
  492.50000     2.31999e+01        0.00000         2.70215e-01          0.95889       554.802     99.0686     0.748255     3.76519e-02     2.94954e-03
  495.00000     2.57056e+01        0.00000         2.94213e-01          0.95604       540.909     99.0686     0.739961     4.17068e-02     3.44987e-03
  497.50000     2.87934e+01        0.00000         3.22726e-01          0.95272       524.366     99.0686     0.730134     4.67276e-02     4.12265e-03
  500.00000     3.28687e+01        0.00000         3.58648e-01          0.94862       503.418     99.0686     0.717705     5.33987e-02     5.11233e-03
  502.50000     3.92980e+01        0.00000         4.11605e-01          0.94273       472.212     99.0686     0.699078     6.40355e-02     6.93408e-03
  503.46193     4.40965e+01        0.00000         4.48361e-01          0.93874       450.245     99.0686     0.685784     7.20705e-02     8.52768e-03
  503.80765     4.94810e+01        0.00000         4.86977e-01          0.93463       426.827     99.0686     0.671352     8.11897e-02     1.05878e-02
  503.80765     4.95307e+01        0.00000         4.87321e-01          0.93460       426.616     99.0686     0.671221     8.12745e-02     1.06083e-02
  503.49540     5.49575e+01        0.00000         5.23578e-01          0.93083       404.246     99.0686     0.657104     9.05807e-02     1.30193e-02
  502.50000     6.09787e+01        0.00000         5.60915e-01          0.92704       380.760     99.0686     0.641849     1.01045e-01     1.61447e-02
  500.00000     6.98129e+01        0.00000         6.10621e-01          0.92217       348.652     99.0686     0.620095     1.16671e-01     2.17573e-02
  497.50000     7.62765e+01        0.00000         6.43486e-01          0.91910       326.800     99.0686     0.604564     1.28314e-01     2.68038e-02
  495.00000     8.17357e+01        0.00000         6.69128e-01          0.91681       309.348     99.0686     0.591657     1.38289e-01     3.18168e-02
  492.50000     8.65959e+01        0.00000         6.90437e-01          0.91500       294.544     99.0686     0.580308     1.47281e-01     3.69599e-02
  490.00000     9.10441e+01        0.00000         7.08763e-01          0.91354       281.571     99.0686     0.570027     1.55603e-01     4.23166e-02
  487.50000     9.51851e+01        0.00000         7.24867e-01          0.91233       269.969     99.0686     0.560538     1.63432e-01     4.79424e-02
  485.00000     9.90844e+01        0.00000         7.39235e-01          0.91132       259.446     99.0686     0.551671     1.70876e-01     5.38808e-02
  482.50000     1.02786e+02        0.00000         7.52197e-01          0.91049       249.803     99.0686     0.543309     1.78008e-01     6.01696e-02
  480.00000     1.06323e+02        0.00000         7.63990e-01          0.90981       240.896     99.0686     0.535369     1.84883e-01     6.68443e-02
  477.50000     1.09717e+02        0.00000         7.74795e-01          0.90926       232.619     99.0686     0.527791     1.91537e-01     7.39394e-02
  475.00000     1.12988e+02        0.00000         7.84749e-01          0.90882       224.887     99.0686     0.520527     1.98001e-01     8.14900e-02
  472.50000     1.16149e+02        0.00000         7.93963e-01          0.90848       217.636     99.0686     0.513541     2.04298e-01     8.95317e-02
  470.00000     1.19211e+02        0.00000         8.02525e-01          0.90824       210.810     99.0686     0.506804     2.10447e-01     9.81020e-02
  467.50000     1.22185e+02        0.00000         8.10510e-01          0.90808       204.366     99.0686     0.500291     2.16462e-01     1.07240e-01
  465.00000     1.25078e+02        0.00000         8.17979e-01          0.90801       198.267     99.0686     0.493982     2.22356e-01     1.16987e-01
  462.50000     1.27896e+02        0.00000         8.24983e-01          0.90800       192.482     99.0686     0.487860     2.28140e-01     1.27386e-01
  460.00000     1.30645e+02        0.00000         8.31568e-01          0.90806       186.982     99.0686     0.481912     2.33822e-01     1.38484e-01
  457.50000     1.33330e+02        0.00000         8.37772e-01          0.90819       181.745     99.0686     0.476125     2.39410e-01     1.50330e-01
  455.00000     1.35955e+02        0.00000         8.43628e-01          0.90838       176.750     99.0686     0.470488     2.44910e-01     1.62978e-01
  452.50000     1.38523e+02        0.00000         8.49166e-01          0.90863       171.980     99.0686     0.464993     2.50328e-01     1.76483e-01
  450.00000     1.41038e+02        0.00000         8.54411e-01          0.90893       167.418     99.0686     0.459631     2.55670e-01     1.90905e-01
  447.50000     1.43503e+02        0.00000         8.59386e-01          0.90929       163.049     99.0686     0.454395     2.60939e-01     2.06309e-01
  445.00000     1.45920e+02        0.00000         8.64111e-01          0.90969       158.862     99.0686     0.449280     2.66139e-01     2.22764e-01
  442.50000     1.48291e+02        0.00000         8.68606e-01          0.91014       154.845     99.0686     0.444278     2.71274e-01     2.40343e-01
  440.00000     1.50618e+02        0.00000         8.72886e-01          0.91064       150.987     99.0686     0.439385     2.76346e-01     2.59126e-01
  437.50000     1.52904e+02        0.00000         8.76966e-01          0.91118       147.279     99.0686     0.434596     2.81359e-01     2.79196e-01
  435.00000     1.55149e+02        0.00000         8.80859e-01          0.91176       143.712     99.0686     0.429908     2.86315e-01     3.00646e-01
  432.50000     1.57355e+02        0.00000         8.84578e-01          0.91238       140.278     99.0686     0.425316     2.91217e-01     3.23573e-01
  430.00000     1.59524e+02        0.00000         8.88133e-01          0.91305       136.970     99.0686     0.420816     2.96065e-01     3.48081e-01
  427.50000     1.61657e+02        0.00000         8.91535e-01          0.91375       133.782     99.0686     0.416407     3.00863e-01     3.74283e-01
  425.00000     1.63755e+02        0.00000         8.94792e-01          0.91449       130.706     99.0686     0.412083     3.05612e-01     4.02300e-01
  422.50000     1.65819e+02        0.00000         8.97914e-01          0.91526       127.738     99.0686     0.407844     3.10313e-01     4.32262e-01
  420.00000     1.67849e+02        0.00000         9.00908e-01          0.91607       124.872     99.0686     0.403686     3.14967e-01     4.64308e-01
  417.50000     1.69848e+02        0.00000         9.03780e-01          0.91691       122.103     99.0686     0.399606     3.19577e-01     4.98589e-01
  415.00000     1.71815e+02        0.00000         9.06538e-01          0.91779       119.427     99.0686     0.395603     3.24144e-01     5.35266e-01
  412.50000     1.73751e+02        0.00000         9.09188e-01          0.91869       116.839     99.0686     0.391674     3.28668e-01     5.74513e-01
  410.00000     1.75658e+02        0.00000         9.11735e-01          0.91963       114.335     99.0686     0.387818     3.33150e-01     6.16518e-01
  407.50000     1.77535e+02        0.00000         9.14184e-01          0.92060       111.911     99.0686     0.384032     3.37592e-01     6.61482e-01
  405.00000     1.79384e+02        0.00000         9.16540e-01          0.92160       109.565     99.0686     0.380314     3.41994e-01     7.09623e-01
  402.50000     1.81204e+02        0.00000         9.18808e-01          0.92262       107.292     99.0686     0.376664     3.46358e-01     7.61175e-01
  400.00000     1.82997e+02        0.00000         9.20991e-01          0.92368       105.089     99.0686     0.373079     3.50684e-01     8.16391e-01
  397.50000     1.84763e+02        0.00000         9.23094e-01          0.92476       102.954     99.0686     0.369557     3.54972e-01     8.75544e-01
  395.00000     1.86502e+02        0.00000         9.25120e-01          0.92586       100.883     99.0686     0.366098     3.59224e-01     9.38927e-01
  393.10156     1.87806e+02        0.00000         9.26608e-01          0.92672        99.354     99.0686     0.363516     3.62429e-01     9.90041e-01
  392.74432     1.88049e+02        0.50000         9.26883e-01          0.92688        99.069     99.0686     0.363030     3.63030e-01     1.00000e+00
        NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
  -14.56203     1.26459e+02        0.00000         1.42822e+00          0.76588       215.435     99.0686     0.887216     7.60823e-01     3.03971e-02
  -14.70872     1.37230e+02        0.00000         1.54817e+00          0.83048       215.161     99.0686     0.887564     7.61830e-01     3.03110e-02
  -14.85506     1.48919e+02        0.00000         1.67801e+00          0.90048       214.869     99.0686     0.887931     7.62889e-01     3.02273e-02
  -15.00000     1.61604e+02        0.00000         1.81854e+00          0.97631       214.558     99.0686     0.888317     7.64001e-01     3.01466e-02
  -15.09884     1.71004e+02        0.00000         1.92241e+00          1.03241       214.331     99.0686     0.888597     7.64802e-01     3.00929e-02
  -15.19607     1.80951e+02        0.00000         2.03210e+00          1.09169       214.096     99.0686     0.888886     7.65629e-01     3.00414e-02
  -15.29127     1.91476e+02        0.00000         2.14791e+00          1.15433       213.851     99.0686     0.889185     7.66482e-01     2.99923e-02
  -15.38401     2.02613e+02        0.00000         2.27017e+00          1.22051       213.596     99.0686     0.889495     7.67362e-01     2.99457e-02
  -15.47381     2.14398e+02        0.00000         2.39922e+00          1.29043       213.333     99.0686     0.889815     7.68268e-01     2.99021e-02
  -15.56020     2.26868e+02        0.00000         2.53544e+00          1.36429       213.061     99.0686     0.890147     7.69200e-01     2.98617e-02
  -15.64269     2.40064e+02        0.00000         2.67919e+00          1.44231       212.779     99.0686     0.890489     7.70159e-01     2.98247e-02
  -15.72078     2.54028e+02        0.00000         2.83089e+00          1.52472       212.488     99.0686     0.890843     7.71145e-01     2.97915e-02
  -15.79394     2.68803e+02        0.00000         2.99095e+00          1.61175       212.189     99.0686     0.891209     7.72157e-01     2.97622e-02
  -15.86166     2.84438e+02        0.00000         3.15983e+00          1.70365       211.881     99.0686     0.891587     7.73195e-01     2.97372e-02
  -15.92341     3.00983e+02        0.00000         3.33798e+00          1.80070       211.566     99.0686     0.891977     7.74259e-01     2.97166e-02
  -15.97864     3.18490e+02        0.00000         3.52590e+00          1.90317       211.242     99.0686     0.892380     7.75349e-01     2.97007e-02
  -16.02683     3.37015e+02        0.00000         3.72410e+00          2.01135       210.911     99.0686     0.892796     7.76465e-01     2.96898e-02
  -16.06744     3.56617e+02        0.00000         3.93314e+00          2.12556       210.574     99.0686     0.893225     7.77605e-01     2.96840e-02
  -16.09994     3.77360e+02        0.00000         4.15359e+00          2.24611       210.230     99.0686     0.893667     7.78770e-01     2.96835e-02
  -16.12381     3.99309e+02        0.00000         4.38604e+00          2.37335       209.880     99.0686     0.894122     7.79959e-01     2.96885e-02
  -16.13855     4.22535e+02        0.00000         4.63115e+00          2.50765       209.526     99.0686     0.894592     7.81171e-01     2.96992e-02
  -16.14367     4.47112e+02        0.00000         4.88958e+00          2.64937       209.167     99.0686     0.895075     7.82406e-01     2.97156e-02
  -15.88642     6.58028e+02        0.00000         7.07348e+00          3.85102       206.654     99.0686     0.898758     7.91393e-01     2.99889e-02
  -15.04874     9.68437e+02        0.00000         1.02056e+01          5.58086       204.232     99.0686     0.903088     8.01092e-01     3.05423e-02
  -13.60666     1.42528e+03        0.00000         1.47049e+01          8.06732       202.144     99.0686     0.907934     8.11076e-01     3.13407e-02
  -11.64422     2.09762e+03        0.00000         2.11903e+01         11.64348       200.544     99.0686     0.913027     8.20850e-01     3.23183e-02
   -9.33992     3.08712e+03        0.00000         3.05787e+01         16.80046       199.454     99.0686     0.918020     8.29932e-01     3.33955e-02
   -6.92237     4.54340e+03        0.00000         4.42276e+01         24.26705       198.794     99.0686     0.922580     8.37939e-01     3.44904e-02
   -4.61133     6.68665e+03        0.00000         6.41440e+01         35.12573       198.439     99.0686     0.926483     8.44652e-01     3.55281e-02
   -2.56845     9.84092e+03        0.00000         9.32918e+01         50.98076       198.269     99.0686     0.929640     8.50027e-01     3.64505e-02
   -0.87609     1.44832e+04        0.00000         1.36042e+02         74.20224       198.200     99.0686     0.932080     8.54165e-01     3.72239e-02
    0.45459     2.13153e+04        0.00000         1.98833e+02        108.28350       198.178     99.0686     0.933898     8.57248e-01     3.78403e-02
    1.45928     3.13702e+04        0.00000         2.91144e+02        158.36700       198.176     99.0686     0.935217     8.59488e-01     3.83115e-02
    2.19506     4.61684e+04        0.00000         4.26923e+02        232.01946       198.182     99.0686     0.936155     8.61084e-01     3.86601e-02
    2.72198     6.79474e+04        0.00000         6.26695e+02        340.37404       198.189     99.0686     0.936813     8.62205e-01     3.89117e-02
    3.09334     1.00000e+05        0.00000         9.20664e+02        499.81246       198.195     99.0686     0.937270     8.62984e-01     3.90900e-02
END

$Env_BP << END
#   Temp        Sat Pres                                                                                    Liq Den      Gas Den           
#    (C)         (bar)        Liq Mole Frac      Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#----------   -----------   ----------------   ---------------   --------------   ---------   ---------   ----------   ----------   -------------
  392.7443      188.049          0.5000            0.92688          0.926883       99.0686     99.0686     0.363030     0.363030     1.00000e+00
  392.3871      188.292          1.0000            0.92705          0.927158       99.0686     98.7849     0.363630     0.362546     9.90043e-01
  390.0000      189.903          1.0000            0.92815          0.928952       99.0686     96.9257     0.367622     0.359360     9.26199e-01
  387.5000      191.564          1.0000            0.92934          0.930766       99.0686     95.0340     0.371768     0.356080     8.63732e-01
  385.0000      193.201          1.0000            0.93054          0.932514       99.0686     93.1971     0.375881     0.352856     8.05468e-01
  382.5000      194.813          1.0000            0.93177          0.934199       99.0686     91.4131     0.379960     0.349687     7.51113e-01
  380.0000      196.400          1.0000            0.93302          0.935825       99.0686     89.6800     0.384006     0.346573     7.00394e-01
  377.5000      197.963          1.0000            0.93430          0.937392       99.0686     87.9957     0.388019     0.343513     6.53062e-01
  375.0000      199.502          1.0000            0.93559          0.938903       99.0686     86.3585     0.392001     0.340505     6.08884e-01
  372.5000      201.018          1.0000            0.93691          0.940359       99.0686     84.7667     0.395951     0.337547     5.67645e-01
  370.0000      202.510          1.0000            0.93825          0.941764       99.0686     83.2186     0.399869     0.334640     5.29145e-01
  367.5000      203.979          1.0000            0.93961          0.943117       99.0686     81.7126     0.403757     0.331782     4.93199e-01
  365.0000      205.425          1.0000            0.94098          0.944422       99.0686     80.2472     0.407615     0.328973     4.59637e-01
  362.5000      206.848          1.0000            0.94238          0.945679       99.0686     78.8210     0.411442     0.326210     4.28299e-01
  360.0000      208.248          1.0000            0.94379          0.946889       99.0686     77.4327     0.415240     0.323494     3.99036e-01
  357.5000      209.626          1.0000            0.94523          0.948055       99.0686     76.0809     0.419009     0.320823     3.71711e-01
  355.0000      210.982          1.0000            0.94668          0.949177       99.0686     74.7644     0.422749     0.318196     3.46197e-01
  352.5000      212.315          1.0000            0.94814          0.950256       99.0686     73.4820     0.426460     0.315614     3.22373e-01
  350.0000      213.626          1.0000            0.94962          0.951293       99.0686     72.2325     0.430142     0.313074     3.00128e-01
  347.5000      214.916          1.0000            0.95112          0.952290       99.0686     71.0149     0.433797     0.310576     2.79360e-01
  345.0000      216.184          1.0000            0.95264          0.953248       99.0686     69.8281     0.437424     0.308119     2.59971e-01
  342.5000      217.430          1.0000            0.95417          0.954166       99.0686     68.6711     0.441023     0.305703     2.41872e-01
  340.0000      218.654          1.0000            0.95571          0.955047       99.0686     67.5429     0.444595     0.303327     2.24978e-01
  337.5000      219.857          1.0000            0.95727          0.955891       99.0686     66.4427     0.448141     0.300990     2.09211e-01
  335.0000      221.038          1.0000            0.95884          0.956698       99.0686     65.3695     0.451659     0.298691     1.94497e-01
  332.5000      222.198          1.0000            0.96043          0.957469       99.0686     64.3225     0.455152     0.296430     1.80769e-01
  330.0000      223.337          1.0000            0.96202          0.958206       99.0686     63.3009     0.458618     0.294206     1.67962e-01
  327.5000      224.454          1.0000            0.96363          0.958908       99.0686     62.3038     0.462058     0.292018     1.56017e-01
  325.0000      225.551          1.0000            0.96525          0.959576       99.0686     61.3307     0.465473     0.289867     1.44877e-01
  322.5000      226.626          1.0000            0.96688          0.960210       99.0686     60.3806     0.468862     0.287750     1.34490e-01
  320.0000      227.680          1.0000            0.96853          0.960812       99.0686     59.4530     0.472226     0.285668     1.24808e-01
  317.5000      228.713          1.0000            0.97018          0.961381       99.0686     58.5471     0.475565     0.283619     1.15784e-01
  315.0000      229.725          1.0000            0.97184          0.961918       99.0686     57.6624     0.478879     0.281605     1.07375e-01
  312.5000      230.715          1.0000            0.97351          0.962423       99.0686     56.7981     0.482169     0.279623     9.95426e-02
  310.0000      231.685          1.0000            0.97519          0.962897       99.0686     55.9538     0.485435     0.277673     9.22480e-02
  307.5000      232.634          1.0000            0.97688          0.963340       99.0686     55.1288     0.488676     0.275755     8.54562e-02
  305.0000      233.562          1.0000            0.97857          0.963752       99.0686     54.3225     0.491893     0.273869     7.91344e-02
  302.5000      234.469          1.0000            0.98027          0.964134       99.0686     53.5345     0.495087     0.272013     7.32518e-02
  300.0000      235.355          1.0000            0.98198          0.964485       99.0686     52.7643     0.498257     0.270187     6.77795e-02
  297.5000      236.219          1.0000            0.98369          0.964807       99.0686     52.0113     0.501404     0.268392     6.26905e-02
  295.0000      237.063          1.0000            0.98541          0.965099       99.0686     51.2751     0.504528     0.266625     5.79594e-02
  292.5000      237.886          1.0000            0.98713          0.965361       99.0686     50.5551     0.507629     0.264888     5.35625e-02
  290.0000      238.687          1.0000            0.98886          0.965593       99.0686     49.8511     0.510708     0.263179     4.94777e-02
  287.5000      239.468          1.0000            0.99059          0.965797       99.0686     49.1625     0.513763     0.261498     4.56842e-02
  285.0000      240.227          1.0000            0.99232          0.965971       99.0686     48.4889     0.516797     0.259845     4.21624e-02
  282.5000      240.965          1.0000            0.99406          0.966116       99.0686     47.8299     0.519808     0.258219     3.88941e-02
  280.0000      241.682          1.0000            0.99579          0.966231       99.0686     47.1852     0.522797     0.256620     3.58623e-02
  277.5000      242.377          1.0000            0.99753          0.966318       99.0686     46.5543     0.525765     0.255048     3.30510e-02
  275.0000      243.051          1.0000            0.99927          0.966376       99.0686     45.9370     0.528711     0.253501     3.04451e-02
  272.5000      243.704          1.0000            1.00101          0.966405       99.0686     45.3328     0.531635     0.251981     2.80308e-02
  270.0000      244.335          1.0000            1.00274          0.966404       99.0686     44.7414     0.534538     0.250486     2.57948e-02
  267.5000      244.944          1.0000            1.00448          0.966375       99.0686     44.1626     0.537420     0.249015     2.37249e-02
  265.0000      245.532          1.0000            1.00621          0.966316       99.0686     43.5959     0.540281     0.247570     2.18096e-02
  262.5000      246.098          1.0000            1.00794          0.966229       99.0686     43.0412     0.543121     0.246149     2.00382e-02
  260.0000      246.643          1.0000            1.00966          0.966112       99.0686     42.4980     0.545941     0.244752     1.84007e-02
  257.5000      247.165          1.0000            1.01138          0.965966       99.0686     41.9661     0.548740     0.243378     1.68876e-02
  255.0000      247.666          1.0000            1.01309          0.965790       99.0686     41.4452     0.551519     0.242028     1.54902e-02
  252.5000      248.144          1.0000            1.01480          0.965585       99.0686     40.9352     0.554277     0.240701     1.42002e-02
  250.0000      248.600          1.0000            1.01650          0.965350       99.0686     40.4356     0.557016     0.239397     1.30101e-02
  247.5000      249.034          1.0000            1.01820          0.965085       99.0686     39.9462     0.559735     0.238116     1.19127e-02
  245.0000      249.445          1.0000            1.01988          0.964790       99.0686     39.4669     0.562434     0.236857     1.09012e-02
  242.5000      249.834          1.0000            1.02156          0.964465       99.0686     38.9973     0.565114     0.235619     9.96952e-03
  240.0000      250.200          1.0000            1.02322          0.964109       99.0686     38.5373     0.567774     0.234404     9.11175e-03
  237.5000      250.544          1.0000            1.02487          0.963722       99.0686     38.0866     0.570416     0.233210     8.32250e-03
  235.0000      250.864          1.0000            1.02651          0.963305       99.0686     37.6450     0.573038     0.232037     7.59671e-03
  232.5000      251.162          1.0000            1.02814          0.962856       99.0686     37.2123     0.575641     0.230885     6.92965e-03
  230.0000      251.436          1.0000            1.02976          0.962376       99.0686     36.7883     0.578226     0.229753     6.31695e-03
  227.5000      251.687          1.0000            1.03136          0.961863       99.0686     36.3728     0.580792     0.228642     5.75451e-03
  225.0000      251.915          1.0000            1.03294          0.961319       99.0686     35.9656     0.583339     0.227551     5.23852e-03
  222.5000      252.119          1.0000            1.03450          0.960742       99.0686     35.5665     0.585868     0.226480     4.76545e-03
  220.0000      252.299          1.0000            1.03605          0.960132       99.0686     35.1753     0.588379     0.225429     4.33200e-03
  217.5000      252.456          1.0000            1.03758          0.959489       99.0686     34.7918     0.590873     0.224396     3.93512e-03
  215.0000      252.588          1.0000            1.03909          0.958813       99.0686     34.4160     0.593348     0.223384     3.57195e-03
  212.5000      252.696          1.0000            1.04057          0.958102       99.0686     34.0475     0.595805     0.222390     3.23985e-03
  210.0000      252.780          1.0000            1.04204          0.957357       99.0686     33.6863     0.598245     0.221414     2.93638e-03
  207.5000      252.839          1.0000            1.04348          0.956577       99.0686     33.3322     0.600667     0.220458     2.65926e-03
  205.0000      252.873          1.0000            1.04489          0.955762       99.0686     32.9851     0.603072     0.219519     2.40638e-03
  202.5000      252.883          1.0000            1.04628          0.954911       99.0686     32.6447     0.605460     0.218598     2.17579e-03
  200.0000      252.867          1.0000            1.04764          0.954023       99.0686     32.3109     0.607831     0.217696     1.96568e-03
  197.5000      252.826          1.0000            1.04897          0.953099       99.0686     31.9837     0.610185     0.216810     1.77436e-03
  195.0000      252.760          1.0000            1.05027          0.952137       99.0686     31.6628     0.612522     0.215942     1.60031e-03
  192.5000      252.668          1.0000            1.05154          0.951137       99.0686     31.3481     0.614843     0.215092     1.44207e-03
  190.0000      252.550          1.0000            1.05278          0.950099       99.0686     31.0395     0.617147     0.214258     1.29832e-03
  187.5000      252.406          1.0000            1.05398          0.949022       99.0686     30.7368     0.619435     0.213440     1.16785e-03
  185.0000      252.235          1.0000            1.05515          0.947904       99.0686     30.4400     0.621706     0.212639     1.04953e-03
  182.5000      252.038          1.0000            1.05628          0.946747       99.0686     30.1489     0.623962     0.211855     9.42303e-04
  180.0000      251.814          1.0000            1.05737          0.945548       99.0686     29.8634     0.626201     0.211086     8.45226e-04
  177.5000      251.564          1.0000            1.05842          0.944308       99.0686     29.5833     0.628425     0.210333     7.57410e-04
  175.0000      251.286          1.0000            1.05942          0.943025       99.0686     29.3086     0.630632     0.209596     6.78043e-04
  172.5000      250.981          1.0000            1.06039          0.941699       99.0686     29.0391     0.632825     0.208873     6.06375e-04
  170.0000      250.647          1.0000            1.06130          0.940329       99.0686     28.7748     0.635001     0.208166     5.41721e-04
  167.5000      250.287          1.0000            1.06217          0.938914       99.0686     28.5154     0.637163     0.207474     4.83449e-04
  165.0000      249.897          1.0000            1.06299          0.937453       99.0686     28.2610     0.639309     0.206797     4.30979e-04
  162.5000      249.480          1.0000            1.06376          0.935946       99.0686     28.0114     0.641440     0.206133     3.83780e-04
  160.0000      249.034          1.0000            1.06447          0.934392       99.0686     27.7666     0.643556     0.205484     3.41365e-04
  157.5000      248.558          1.0000            1.06513          0.932790       99.0686     27.5263     0.645658     0.204849     3.03288e-04
  155.0000      248.054          1.0000            1.06573          0.931139       99.0686     27.2906     0.647744     0.204228     2.69142e-04
  152.5000      247.520          1.0000            1.06628          0.929438       99.0686     27.0593     0.649816     0.203620     2.38552e-04
  150.0000      246.957          1.0000            1.06676          0.927686       99.0686     26.8323     0.651874     0.203025     2.11180e-04
  147.5000      246.363          1.0000            1.06717          0.925881       99.0686     26.6096     0.653917     0.202443     1.86713e-04
  145.0000      245.739          1.0000            1.06752          0.924024       99.0686     26.3910     0.655946     0.201874     1.64868e-04
  142.5000      245.085          1.0000            1.06780          0.922113       99.0686     26.1766     0.657960     0.201318     1.45387e-04
  140.0000      244.399          1.0000            1.06801          0.920147       99.0686     25.9661     0.659961     0.200774     1.28035e-04
  137.5000      243.682          1.0000            1.06814          0.918124       99.0686     25.7595     0.661948     0.200241     1.12599e-04
  135.0000      242.934          1.0000            1.06820          0.916044       99.0686     25.5567     0.663921     0.199721     9.88837e-05
  132.5000      242.154          1.0000            1.06818          0.913905       99.0686     25.3577     0.665881     0.199212     8.67132e-05
  130.0000      241.342          1.0000            1.06808          0.911707       99.0686     25.1623     0.667826     0.198714     7.59277e-05
  127.5000      240.497          1.0000            1.06789          0.909447       99.0686     24.9706     0.669759     0.198227     6.63825e-05
  125.0000      239.620          1.0000            1.06762          0.907125       99.0686     24.7824     0.671678     0.197750     5.79467e-05
  122.5000      238.709          1.0000            1.06726          0.904740       99.0686     24.5976     0.673584     0.197285     5.05020e-05
  120.0000      237.765          1.0000            1.06680          0.902289       99.0686     24.4162     0.675477     0.196829     4.39413e-05
  117.5000      236.788          1.0000            1.06624          0.899771       99.0686     24.2381     0.677356     0.196383     3.81685e-05
  115.0000      235.776          1.0000            1.06559          0.897186       99.0686     24.0632     0.679223     0.195946     3.30966e-05
  112.5000      234.729          1.0000            1.06483          0.894532       99.0686     23.8916     0.681077     0.195519     2.86477e-05
  110.0000      233.648          1.0000            1.06396          0.891806       99.0686     23.7230     0.682919     0.195100     2.47514e-05
  107.5000      232.531          1.0000            1.06299          0.889008       99.0686     23.5575     0.684747     0.194690     2.13448e-05
  105.0000      231.379          1.0000            1.06189          0.886136       99.0686     23.3949     0.686564     0.194289     1.83715e-05
  102.5000      230.191          1.0000            1.06069          0.883188       99.0686     23.2353     0.688368     0.193895     1.57809e-05
  100.0000      228.967          1.0000            1.05935          0.880163       99.0686     23.0785     0.690160     0.193508     1.35278e-05
   97.5000      227.706          1.0000            1.05790          0.877058       99.0686     22.9245     0.691939     0.193129     1.15720e-05
   95.0000      226.407          1.0000            1.05631          0.873873       99.0686     22.7733     0.693707     0.192756     9.87741e-06
   92.5000      225.072          1.0000            1.05459          0.870604       99.0686     22.6247     0.695463     0.192390     8.41210e-06
   90.0000      223.698          1.0000            1.05273          0.867251       99.0686     22.4788     0.697206     0.192030     7.14762e-06
   87.5000      222.286          1.0000            1.05072          0.863812       99.0686     22.3354     0.698939     0.191675     6.05874e-06
   85.0000      220.835          1.0000            1.04857          0.860284       99.0686     22.1945     0.700659     0.191326     5.12310e-06
   82.5000      219.345          1.0000            1.04627          0.856665       99.0686     22.0561     0.702368     0.190981     4.32095e-06
   80.0000      217.815          1.0000            1.04380          0.852954       99.0686     21.9202     0.704065     0.190640     3.63483e-06
   77.5000      216.246          1.0000            1.04117          0.849147       99.0686     21.7865     0.705752     0.190302     3.04935e-06
   75.0000      214.636          1.0000            1.03838          0.845244       99.0686     21.6552     0.707426     0.189968     2.55099e-06
   72.5000      212.985          1.0000            1.03541          0.841242       99.0686     21.5261     0.709090     0.189636     2.12788e-06
   70.0000      211.292          1.0000            1.03226          0.837139       99.0686     21.3992     0.710743     0.189307     1.76959e-06
   67.5000      209.558          1.0000            1.02892          0.832932       99.0686     21.2745     0.712385     0.188978     1.46704e-06
   65.0000      207.782          1.0000            1.02540          0.828619       99.0686     21.1519     0.714016     0.188651     1.21227e-06
   62.5000      205.962          1.0000            1.02167          0.824197       99.0686     21.0314     0.715636     0.188323     9.98381e-07
   60.0000      204.100          1.0000            1.01774          0.819665       99.0686     20.9128     0.717246     0.187995     8.19354e-07
   57.5000      202.194          1.0000            1.01360          0.815019       99.0686     20.7963     0.718845     0.187665     6.69987e-07
   55.0000      200.244          1.0000            1.00924          0.810258       99.0686     20.6816     0.720433     0.187333     5.45777e-07
   52.5000      198.249          1.0000            1.00466          0.805378       99.0686     20.5688     0.722011     0.186997     4.42844e-07
   50.0000      196.209          1.0000            0.99984          0.800378       99.0686     20.4579     0.723579     0.186658     3.57848e-07
   47.5000      194.124          1.0000            0.99478          0.795255       99.0686     20.3487     0.725137     0.186313     2.87926e-07
   45.0000      191.992          1.0000            0.98948          0.790005       99.0686     20.2413     0.726685     0.185963     2.30629e-07
   42.5000      189.814          1.0000            0.98392          0.784627       99.0686     20.1356     0.728223     0.185605     1.83869e-07
   40.0000      187.589          1.0000            0.97810          0.779118       99.0686     20.0315     0.729750     0.185239     1.45871e-07
   37.5000      185.316          1.0000            0.97200          0.773475       99.0686     19.9291     0.731268     0.184862     1.15131e-07
   35.0000      182.996          1.0000            0.96562          0.767697       99.0686     19.8282     0.732777     0.184475     9.03782e-08
   32.5000      180.626          1.0000            0.95896          0.761780       99.0686     19.7288     0.734275     0.184075     7.05449e-08
   30.0000      178.208          1.0000            0.95199          0.755722       99.0686     19.6309     0.735765     0.183660     5.47354e-08
   27.5000      175.741          1.0000            0.94472          0.749521       99.0686     19.5345     0.737244     0.183229     4.22016e-08
   25.0000      173.223          1.0000            0.93712          0.743174       99.0686     19.4394     0.738715     0.182780     3.23217e-08
   22.5000      170.655          1.0000            0.92920          0.736681       99.0686     19.3457     0.740176     0.182311     2.45809e-08
   20.0000      168.037          1.0000            0.92094          0.730039       99.0686     19.2533     0.741628     0.181819     1.85547e-08
   17.5000      165.367          1.0000            0.91232          0.723246       99.0686     19.1621     0.743071     0.181301     1.38952e-08
   15.0000      162.645          1.0000            0.90335          0.716302       99.0686     19.0721     0.744505     0.180756     1.03183e-08
   12.5000      159.872          1.0000            0.89401          0.709206       99.0686     18.9834     0.745930     0.180179     7.59351e-09
   10.0000      157.046          1.0000            0.88428          0.701958       99.0686     18.8957     0.747347     0.179568     5.53475e-09
    7.5000      154.167          1.0000            0.87416          0.694558       99.0686     18.8091     0.748755     0.178918     3.99278e-09
    5.0000      151.236          1.0000            0.86363          0.687007       99.0686     18.7235     0.750154     0.178225     2.84868e-09
    2.5000      148.251          1.0000            0.85268          0.679307       99.0686     18.6389     0.751545     0.177485     2.00830e-09
    0.0000      145.213          1.0000            0.84131          0.671462       99.0686     18.5552     0.752928     0.176691     1.39771e-09
   -2.5000      142.122          1.0000            0.82949          0.663477       99.0686     18.4724     0.754303     0.175839     9.59261e-10
   -5.0000      138.977          1.0000            0.81721          0.655356       99.0686     18.3903     0.755669     0.174921     6.48419e-10
   -7.5000      135.779          1.0000            0.80447          0.647110       99.0686     18.3090     0.757028     0.173930     4.31092e-10
  -10.0000      132.527          1.0000            0.79126          0.638747       99.0686     18.2284     0.758378     0.172857     2.81442e-10
  -12.5000      129.223          1.0000            0.77755          0.630283       99.0686     18.1484     0.759721     0.171692     1.80103e-10
  -14.5620      126.459          1.0000            0.76588          0.623238       99.0686     18.0828     0.760823     0.170654     1.22584e-10
END

set output "Figures/Env_001_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:4.5e+02] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_001_LogP_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_001_LogP_vs_TI_1.pdf"
set xlabel "1/Temperature (1/K)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using (1/($1+273.15)):2 with lines title "Dew Points", \
     $Env_BP using (1/($1+273.15)):2 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_001_P_vs_TI_1.pdf"
set xlabel "1/Temperature (1/K)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:4.5e+02] \
     $Env_DP using (1/($1+273.15)):2 with lines title "Dew Points", \
     $Env_BP using (1/($1+273.15)):2 with lines title "Bubble Points"

set title "Constant Composition Expansion of Oil Sample 1"
show title

$Expt << END
#           Pres          Rel Vol          Liq Sat (%)       Liq Den (g/cm3)
#  Stg      (bar)      Expt    Calc       Expt    Calc        Expt     Calc
#------   --------   ----------------   ----------------   ------------------
     1     981.73     0.9130  0.9049     100.00  100.00     0.76800  0.76127
     2     930.09     0.9160  0.9082     100.00  100.00     0.76600  0.75851
     3     861.28     0.9210  0.9129     100.00  100.00     0.76100  0.75455
     4     758.96     0.9300  0.9209     100.00  100.00     0.75400  0.74799
     5     647.82     0.9410  0.9312     100.00  100.00     0.74500  0.73975
     6     585.70     0.9480  0.9379     100.00  100.00     0.74000  0.73450
     7     516.41     0.9560  0.9463     100.00  100.00     0.73400  0.72798
     8     481.11     0.9600  0.9510     100.00  100.00     0.73000  0.72434
     9     445.60     0.9650  0.9562     100.00  100.00     0.72700  0.72042
    10     411.13     0.9700  0.9616     100.00  100.00     0.72300  0.71635
    11     372.66     0.9750  0.9683     100.00  100.00     0.71900  0.71144
    12     354.11     0.9790  0.9717     100.00  100.00     0.71600  0.70892
    13     310.54     0.9850  0.9805     100.00  100.00     0.71100  0.70256
    14     275.92     0.9920  0.9883     100.00  100.00     0.70700  0.69699
    15     242.90     0.9990  0.9967     100.00  100.00     0.70200  0.69117
    16     230.63     1.0000  1.0000     100.00  100.00     0.70100  0.68886
    17     227.66     1.0030  1.0032      99.94   99.35         NaN  0.68987
    18     206.77     1.0300  1.0352      95.27   93.41         NaN  0.70022
    19     190.29     1.0580  1.0677      91.25   88.56         NaN  0.70829
    20     155.13     1.1460  1.1690      81.88   77.32         NaN  0.72548
    21     120.45     1.3050  1.3462      69.78   64.34         NaN  0.74266
    22      54.33     2.3520  2.4821      36.41   31.98         NaN  0.77841
END
set xlabel "Pressure (bar)"
set ylabel "Relative Volume"
set output "Figures/Expt_007_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_007_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_007_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"

set title "Differential Liberation of Oil Sample 1"
show title

$Expt << END
#           Temp        Pres                   Tot Vol 2 (m3)      Removed (sm3)      Liq Den (g/cm3)      Liq Vis (cp)         Gas Den (g/cm3)       Gas Sp Gravity      Gas Z-Factor
#  Stg       (C)       (bar)       Stg Wgt      Expt    Calc       Expt    Calc        Expt     Calc       Expt    Calc         Expt       Calc        Expt    Calc       Expt    Calc
#------   --------   ---------   ----------   ----------------   ----------------   ------------------   ----------------   ----------------------   ----------------   ----------------
     1     102.00     354.110       1.00          NaN  1.4274        NaN    0.00         NaN  0.70892     0.5870  0.5333           NaN  0.3261009        NaN  0.9956        NaN  1.0039
     2     102.00     330.940       1.00          NaN  1.4341        NaN    0.00         NaN  0.70562     0.5740  0.5117           NaN  0.2983554        NaN  0.9424        NaN  0.9707
     3     102.00     303.360       1.00          NaN  1.4426        NaN    0.00         NaN  0.70145     0.5570  0.4859           NaN  0.2677817        NaN  0.8920        NaN  0.9384
     4     102.00     275.850       1.00          NaN  1.4519        NaN    0.00         NaN  0.69698     0.5420  0.4601           NaN  0.2390730        NaN  0.8518        NaN  0.9126
     5     102.00     248.280       1.00          NaN  1.4620        NaN    0.00         NaN  0.69215     0.5270  0.4341           NaN  0.2115640        NaN  0.8192        NaN  0.8927
     6     102.00     234.420       1.00          NaN  1.4675        NaN    0.00         NaN  0.68958     0.5190  0.4210           NaN  0.1981096        NaN  0.8053        NaN  0.8848
     7     102.00     230.630       1.00       1.4690  1.4690       0.00    0.00         NaN  0.68886     0.5170  0.4174           NaN  0.1944689        NaN  0.8017        NaN  0.8829
     8     102.00     175.810       1.00       1.4130  1.3629      35.10   39.64         NaN  0.71537     0.7370  0.5371     0.1373000  0.1434546     0.7340  0.7621     0.8730  0.8673
     9     102.00     113.760       1.00       1.3180  1.2606      70.80   77.71         NaN  0.74596     0.8840  0.7261     0.0849000  0.0896693     0.7120  0.7445     0.8860  0.8771
    10     102.00      44.820       1.00       1.2140  1.1562     107.90  115.05         NaN  0.78184     1.2500  1.0425     0.0344000  0.0359269     0.7670  0.7965     0.9280  0.9227
    11     102.00      13.790       1.00       1.1610  1.1007     124.50  132.81         NaN  0.80121     1.5150  1.2683     0.0126000  0.0136456     0.9410  1.0175     0.9600  0.9548
    12     102.00       3.030       0.00       1.1160  1.0511     138.30  145.00         NaN  0.81524     1.7510  1.4744     0.0043000  0.0048594     1.5060  1.6774     0.9760  0.9712
    13     102.00       1.010       0.00       1.0760  1.0080     146.00  153.43         NaN  0.82486     2.0380  1.6526     0.0020000  0.0023625     2.0930  2.4680     0.9840  0.9797
    14      15.00       1.010       0.00       1.0000  0.9637        NaN  153.43     0.86900  0.86274        NaN  2.8784           NaN  0.0008879        NaN  0.7243        NaN  0.9961
END
set xlabel "Pressure (bar)"
set ylabel "Volume, After Removal (m3)"
set output "Figures/Expt_008_V2_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_008_MR_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_008_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_008_LVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Density (g/cm3)"
set output "Figures/Expt_008_GDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_008_GSG_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:15 with points title "Expt", $Expt using 3:16 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_008_GZ_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"

set title "Phase Envelope for Oil Sample 2"
show title

$Env_DP << END
#     Temp           Sat Pres                                                                                     Liq Den       Gas Den             
#      (C)            (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#--------------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   4.44731e+01     1.00000e-13        0.00000         2.88068e-15          1.00000       737.351     104.915     0.969243     3.97275e-16     9.52985e-18
   4.50000e+01     1.11333e-13        0.00000         3.20209e-15          1.00000       737.351     104.915     0.969167     4.41567e-16     1.05839e-17
   4.75000e+01     1.84262e-13        0.00000         5.26029e-15          1.00000       737.351     104.915     0.968802     7.25117e-16     1.73174e-17
   5.00000e+01     3.02207e-13        0.00000         8.56388e-15          1.00000       737.351     104.915     0.968435     1.18006e-15     2.80873e-17
   5.25000e+01     4.91280e-13        0.00000         1.38202e-14          1.00000       737.351     104.915     0.968065     1.90363e-15     4.51667e-17
   5.50000e+01     7.91775e-13        0.00000         2.21122e-14          1.00000       737.351     104.915     0.967691     3.04462e-15     7.20280e-17
   5.75000e+01     1.26536e-12        0.00000         3.50847e-14          1.00000       737.351     104.915     0.967315     4.82890e-15     1.13932e-16
   6.00000e+01     2.00564e-12        0.00000         5.52148e-14          1.00000       737.351     104.915     0.966935     7.59655e-15     1.78786e-16
   6.25000e+01     3.15358e-12        0.00000         8.62050e-14          1.00000       737.351     104.915     0.966552     1.18555e-14     2.78390e-16
   6.50000e+01     4.91984e-12        0.00000         1.33546e-13          1.00000       737.351     104.915     0.966166     1.83588e-14     4.30210e-16
   6.75000e+01     7.61680e-12        0.00000         2.05318e-13          1.00000       737.351     104.915     0.965777     2.82142e-14     6.59924e-16
   7.00000e+01     1.17043e-11        0.00000         3.13330e-13          1.00000       737.351     104.915     0.965385     4.30394e-14     1.00501e-15
   7.25000e+01     1.78546e-11        0.00000         4.74711e-13          1.00000       737.351     104.915     0.964990     6.51803e-14     1.51977e-15
   7.50000e+01     2.70428e-11        0.00000         7.14139e-13          1.00000       737.351     104.915     0.964591     9.80143e-14     2.28240e-15
   7.75000e+01     4.06750e-11        0.00000         1.06692e-12          1.00000       737.351     104.915     0.964189     1.46372e-13     3.40469e-15
   8.00000e+01     6.07636e-11        0.00000         1.58323e-12          1.00000       737.351     104.915     0.963784     2.17114e-13     5.04551e-15
   8.25000e+01     9.01709e-11        0.00000         2.33393e-12          1.00000       737.351     104.915     0.963375     3.19924e-13     7.42911e-15
   8.50000e+01     1.32942e-10        0.00000         3.41843e-12          1.00000       737.350     104.915     0.962963     4.68383e-13     1.08702e-14
   8.75000e+01     1.94757e-10        0.00000         4.97535e-12          1.00000       737.350     104.915     0.962548     6.81413e-13     1.58075e-14
   9.00000e+01     2.83544e-10        0.00000         7.19681e-12          1.00000       737.350     104.915     0.962129     9.85229e-13     2.28496e-14
   9.25000e+01     4.10301e-10        0.00000         1.03475e-11          1.00000       737.350     104.915     0.961707     1.41593e-12     3.28352e-14
   9.50000e+01     5.90200e-10        0.00000         1.47898e-11          1.00000       737.350     104.915     0.961282     2.02292e-12     4.69138e-14
   9.75000e+01     8.44043e-10        0.00000         2.10176e-11          1.00000       737.350     104.915     0.960853     2.87345e-12     6.66525e-14
   1.00000e+02     1.20020e-09        0.00000         2.96995e-11          1.00000       737.350     104.915     0.960420     4.05859e-12     9.41762e-14
   1.02500e+02     1.69716e-09        0.00000         4.17363e-11          1.00000       737.349     104.915     0.959984     5.70088e-12     1.32350e-13
   1.05000e+02     2.38681e-09        0.00000         5.83348e-11          1.00000       737.349     104.915     0.959544     7.96447e-12     1.85020e-13
   1.07500e+02     3.33881e-09        0.00000         8.11037e-11          1.00000       737.349     104.915     0.959101     1.10680e-11     2.57317e-13
   1.10000e+02     4.64616e-09        0.00000         1.12177e-10          1.00000       737.349     104.915     0.958654     1.53013e-11     3.56062e-13
   1.12500e+02     6.43237e-09        0.00000         1.54368e-10          1.00000       737.348     104.915     0.958203     2.10466e-11     4.90267e-13
   1.15000e+02     8.86072e-09        0.00000         2.11376e-10          1.00000       737.348     104.915     0.957748     2.88054e-11     6.71793e-13
   1.17500e+02     1.21460e-08        0.00000         2.88032e-10          1.00000       737.347     104.915     0.957290     3.92328e-11     9.16173e-13
   1.20000e+02     1.65694e-08        0.00000         3.90619e-10          1.00000       737.347     104.915     0.956828     5.31806e-11     1.24366e-12
   1.22500e+02     2.24975e-08        0.00000         5.27276e-10          1.00000       737.346     104.915     0.956362     7.17508e-11     1.68054e-12
   1.25000e+02     3.04057e-08        0.00000         7.08493e-10          1.00000       737.346     104.915     0.955893     9.63633e-11     2.26078e-12
   1.27500e+02     4.09081e-08        0.00000         9.47735e-10          1.00000       737.345     104.915     0.955419     1.28839e-10     3.02810e-12
   1.30000e+02     5.47946e-08        0.00000         1.26221e-09          1.00000       737.344     104.915     0.954942     1.71504e-10     4.03852e-12
   1.32500e+02     7.30765e-08        0.00000         1.67380e-09          1.00000       737.343     104.915     0.954460     2.27316e-10     5.36354e-12
   1.35000e+02     9.70437e-08        0.00000         2.21027e-09          1.00000       737.342     104.915     0.953975     3.00021e-10     7.09406e-12
   1.37500e+02     1.28334e-07        0.00000         2.90664e-09          1.00000       737.341     104.915     0.953486     3.94343e-10     9.34517e-12
   1.40000e+02     1.69020e-07        0.00000         3.80693e-09          1.00000       737.340     104.915     0.952992     5.16220e-10     1.22620e-11
   1.42500e+02     2.21713e-07        0.00000         4.96630e-09          1.00000       737.338     104.915     0.952495     6.73080e-10     1.60271e-11
   1.45000e+02     2.89689e-07        0.00000         6.45354e-09          1.00000       737.337     104.915     0.951993     8.74185e-10     2.08688e-11
   1.47500e+02     3.77047e-07        0.00000         8.35415e-09          1.00000       737.335     104.915     0.951487     1.13104e-09     2.70719e-11
   1.50000e+02     4.88892e-07        0.00000         1.07740e-08          1.00000       737.333     104.915     0.950977     1.45788e-09     3.49909e-11
   1.52500e+02     6.31562e-07        0.00000         1.38438e-08          1.00000       737.331     104.915     0.950462     1.87226e-09     4.50643e-11
   1.55000e+02     8.12896e-07        0.00000         1.77243e-08          1.00000       737.329     104.915     0.949944     2.39576e-09     5.78340e-11
   1.57500e+02     1.04256e-06        0.00000         2.26122e-08          1.00000       737.326     104.915     0.949420     3.05477e-09     7.39664e-11
   1.60000e+02     1.33242e-06        0.00000         2.87480e-08          1.00000       737.323     104.915     0.948893     3.88155e-09     9.42790e-11
   1.62500e+02     1.69700e-06        0.00000         3.64244e-08          1.00000       737.320     104.915     0.948361     4.91528e-09     1.19771e-10
   1.65000e+02     2.15405e-06        0.00000         4.59965e-08          1.00000       737.317     104.915     0.947825     6.20349e-09     1.51661e-10
   1.67500e+02     2.72513e-06        0.00000         5.78936e-08          1.00000       737.313     104.915     0.947284     7.80362e-09     1.91427e-10
   1.70000e+02     3.43638e-06        0.00000         7.26334e-08          1.00000       737.309     104.915     0.946738     9.78485e-09     2.40863e-10
   1.72500e+02     4.31943e-06        0.00000         9.08380e-08          1.00000       737.305     104.915     0.946188     1.22303e-08     3.02131e-10
   1.75000e+02     5.41235e-06        0.00000         1.13253e-07          1.00000       737.300     104.915     0.945633     1.52393e-08     3.77839e-10
   1.77500e+02     6.76090e-06        0.00000         1.40769e-07          1.00000       737.295     104.915     0.945074     1.89308e-08     4.71114e-10
   1.80000e+02     8.41989e-06        0.00000         1.74446e-07          1.00000       737.289     104.915     0.944509     2.34460e-08     5.85703e-10
   1.82500e+02     1.04548e-05        0.00000         2.15546e-07          1.00000       737.283     104.915     0.943940     2.89526e-08     7.26078e-10
   1.85000e+02     1.29436e-05        0.00000         2.65560e-07          1.00000       737.276     104.915     0.943366     3.56492e-08     8.97564e-10
   1.87500e+02     1.59788e-05        0.00000         3.26250e-07          1.00000       737.269     104.915     0.942787     4.37700e-08     1.10649e-09
   1.90000e+02     1.96702e-05        0.00000         3.99695e-07          1.00000       737.261     104.915     0.942203     5.35908e-08     1.36034e-09
   1.92500e+02     2.41472e-05        0.00000         4.88333e-07          1.00000       737.252     104.915     0.941614     6.54352e-08     1.66797e-09
   1.95000e+02     2.95625e-05        0.00000         5.95023e-07          1.00000       737.243     104.915     0.941020     7.96821e-08     2.03981e-09
   1.97500e+02     3.60955e-05        0.00000         7.23107e-07          1.00000       737.233     104.915     0.940421     9.67740e-08     2.48813e-09
   2.00000e+02     4.39562e-05        0.00000         8.76480e-07          1.00000       737.222     104.915     0.939817     1.17226e-07     3.02730e-09
   2.02500e+02     5.33903e-05        0.00000         1.05967e-06          1.00000       737.210     104.915     0.939207     1.41638e-07     3.67415e-09
   2.05000e+02     6.46845e-05        0.00000         1.27793e-06          1.00000       737.197     104.915     0.938592     1.70703e-07     4.44832e-09
   2.07500e+02     7.81719e-05        0.00000         1.53735e-06          1.00000       737.184     104.915     0.937971     2.05223e-07     5.37268e-09
   2.10000e+02     9.42395e-05        0.00000         1.84495e-06          1.00000       737.169     104.915     0.937345     2.46125e-07     6.47381e-09
   2.12500e+02     1.13335e-04        0.00000         2.20881e-06          1.00000       737.153     104.915     0.936714     2.94473e-07     7.78250e-09
   2.15000e+02     1.35976e-04        0.00000         2.63822e-06          1.00000       737.136     104.915     0.936077     3.51491e-07     9.33440e-09
   2.17500e+02     1.62759e-04        0.00000         3.14385e-06          1.00000       737.117     104.915     0.935434     4.18579e-07     1.11707e-08
   2.20000e+02     1.94369e-04        0.00000         3.73790e-06          1.00000       737.098     104.915     0.934786     4.97340e-07     1.33386e-08
   2.22500e+02     2.31594e-04        0.00000         4.43427e-06          1.00000       737.076     104.915     0.934131     5.89599e-07     1.58928e-08
   2.25000e+02     2.75333e-04        0.00000         5.24883e-06          1.00000       737.054     104.915     0.933471     6.97435e-07     1.88958e-08
   2.27500e+02     3.26618e-04        0.00000         6.19962e-06          1.00000       737.029     104.915     0.932805     8.23210e-07     2.24189e-08
   2.30000e+02     3.86620e-04        0.00000         7.30708e-06          1.00000       737.003     104.915     0.932133     9.69599e-07     2.65441e-08
   2.32500e+02     4.56675e-04        0.00000         8.59438e-06          0.99999       736.975     104.915     0.931454     1.13963e-06     3.13646e-08
   2.35000e+02     5.38299e-04        0.00000         1.00877e-05          0.99999       736.946     104.915     0.930770     1.33671e-06     3.69865e-08
   2.37500e+02     6.33210e-04        0.00000         1.18165e-05          0.99999       736.914     104.915     0.930079     1.56470e-06     4.35304e-08
   2.40000e+02     7.43352e-04        0.00000         1.38140e-05          0.99999       736.880     104.915     0.929381     1.82792e-06     5.11332e-08
   2.42500e+02     8.70916e-04        0.00000         1.61175e-05          0.99999       736.843     104.915     0.928678     2.13122e-06     5.99496e-08
   2.45000e+02     1.01838e-03        0.00000         1.87689e-05          0.99999       736.805     104.915     0.927967     2.48005e-06     7.01548e-08
   2.47500e+02     1.18851e-03        0.00000         2.18149e-05          0.99999       736.763     104.915     0.927250     2.88048e-06     8.19461e-08
   2.50000e+02     1.38443e-03        0.00000         2.53078e-05          0.99999       736.719     104.915     0.926526     3.33929e-06     9.55460e-08
   2.52500e+02     1.60964e-03        0.00000         2.93060e-05          0.99998       736.672     104.915     0.925796     3.86405e-06     1.11205e-07
   2.55000e+02     1.86804e-03        0.00000         3.38744e-05          0.99998       736.622     104.915     0.925058     4.46315e-06     1.29202e-07
   2.57500e+02     2.16400e-03        0.00000         3.90850e-05          0.99998       736.569     104.915     0.924313     5.14592e-06     1.49854e-07
   2.60000e+02     2.50239e-03        0.00000         4.50179e-05          0.99998       736.513     104.915     0.923562     5.92269e-06     1.73512e-07
   2.62500e+02     2.88860e-03        0.00000         5.17617e-05          0.99997       736.453     104.915     0.922802     6.80490e-06     2.00569e-07
   2.65000e+02     3.32865e-03        0.00000         5.94143e-05          0.99997       736.390     104.915     0.922036     7.80517e-06     2.31463e-07
   2.67500e+02     3.82921e-03        0.00000         6.80838e-05          0.99996       736.322     104.915     0.921262     8.93742e-06     2.66685e-07
   2.70000e+02     4.39766e-03        0.00000         7.78894e-05          0.99996       736.250     104.915     0.920480     1.02170e-05     3.06777e-07
   2.72500e+02     5.04214e-03        0.00000         8.89622e-05          0.99996       736.174     104.915     0.919690     1.16607e-05     3.52343e-07
   2.75000e+02     5.77166e-03        0.00000         1.01446e-04          0.99995       736.094     104.915     0.918893     1.32870e-05     4.04053e-07
   2.77500e+02     6.59614e-03        0.00000         1.15499e-04          0.99994       736.009     104.915     0.918087     1.51162e-05     4.62648e-07
   2.80000e+02     7.52649e-03        0.00000         1.31294e-04          0.99994       735.918     104.915     0.917273     1.71704e-05     5.28950e-07
   2.82500e+02     8.57469e-03        0.00000         1.49021e-04          0.99993       735.823     104.915     0.916451     1.94739e-05     6.03864e-07
   2.85000e+02     9.75390e-03        0.00000         1.68885e-04          0.99992       735.722     104.915     0.915621     2.20529e-05     6.88391e-07
   2.87500e+02     1.10785e-02        0.00000         1.91112e-04          0.99991       735.615     104.915     0.914781     2.49363e-05     7.83631e-07
   2.90000e+02     1.25643e-02        0.00000         2.15948e-04          0.99990       735.502     104.915     0.913933     2.81554e-05     8.90799e-07
   2.92500e+02     1.42284e-02        0.00000         2.43658e-04          0.99989       735.383     104.915     0.913076     3.17440e-05     1.01123e-06
   2.95000e+02     1.60897e-02        0.00000         2.74533e-04          0.99988       735.257     104.915     0.912210     3.57391e-05     1.14638e-06
   2.97500e+02     1.81686e-02        0.00000         3.08887e-04          0.99986       735.124     104.915     0.911335     4.01805e-05     1.29785e-06
   3.00000e+02     2.04873e-02        0.00000         3.47059e-04          0.99985       734.983     104.915     0.910450     4.51115e-05     1.46742e-06
   3.02500e+02     2.30700e-02        0.00000         3.89417e-04          0.99983       734.835     104.915     0.909555     5.05786e-05     1.65699e-06
   3.05000e+02     2.59429e-02        0.00000         4.36359e-04          0.99981       734.679     104.915     0.908651     5.66323e-05     1.86868e-06
   3.07500e+02     2.91345e-02        0.00000         4.88314e-04          0.99979       734.514     104.915     0.907737     6.33268e-05     2.10478e-06
   3.10000e+02     3.26754e-02        0.00000         5.45742e-04          0.99977       734.340     104.915     0.906812     7.07204e-05     2.36779e-06
   3.12500e+02     3.65991e-02        0.00000         6.09141e-04          0.99975       734.158     104.915     0.905877     7.88762e-05     2.66044e-06
   3.15000e+02     4.09412e-02        0.00000         6.79045e-04          0.99972       733.965     104.915     0.904931     8.78614e-05     2.98572e-06
   3.17500e+02     4.57407e-02        0.00000         7.56029e-04          0.99969       733.762     104.915     0.903974     9.77486e-05     3.34685e-06
   3.20000e+02     5.10393e-02        0.00000         8.40706e-04          0.99966       733.549     104.915     0.903006     1.08615e-04     3.74735e-06
   3.22500e+02     5.68818e-02        0.00000         9.33737e-04          0.99963       733.325     104.915     0.902027     1.20544e-04     4.19104e-06
   3.25000e+02     6.33166e-02        0.00000         1.03583e-03          0.99959       733.089     104.915     0.901036     1.33625e-04     4.68206e-06
   3.27500e+02     7.03955e-02        0.00000         1.14773e-03          0.99955       732.841     104.915     0.900033     1.47952e-04     5.22491e-06
   3.30000e+02     7.81742e-02        0.00000         1.27025e-03          0.99951       732.580     104.915     0.899018     1.63627e-04     5.82446e-06
   3.32500e+02     8.67124e-02        0.00000         1.40426e-03          0.99947       732.306     104.915     0.897991     1.80757e-04     6.48599e-06
   3.35000e+02     9.60740e-02        0.00000         1.55065e-03          0.99942       732.018     104.915     0.896951     1.99458e-04     7.21520e-06
   3.37500e+02     1.06327e-01        0.00000         1.71042e-03          0.99937       731.716     104.915     0.895897     2.19852e-04     8.01827e-06
   3.40000e+02     1.17545e-01        0.00000         1.88459e-03          0.99931       731.399     104.915     0.894831     2.42071e-04     8.90187e-06
   3.42500e+02     1.29806e-01        0.00000         2.07428e-03          0.99925       731.066     104.915     0.893751     2.66251e-04     9.87322e-06
   3.45000e+02     1.43194e-01        0.00000         2.28066e-03          0.99918       730.716     104.915     0.892656     2.92542e-04     1.09401e-05
   3.47500e+02     1.57796e-01        0.00000         2.50496e-03          0.99912       730.350     104.915     0.891548     3.21098e-04     1.21109e-05
   3.50000e+02     1.73708e-01        0.00000         2.74852e-03          0.99904       729.965     104.915     0.890425     3.52085e-04     1.33947e-05
   3.52500e+02     1.91031e-01        0.00000         3.01272e-03          0.99896       729.562     104.915     0.889286     3.85680e-04     1.48014e-05
   3.55000e+02     2.09872e-01        0.00000         3.29905e-03          0.99888       729.139     104.915     0.888132     4.22068e-04     1.63413e-05
   3.57500e+02     2.30344e-01        0.00000         3.60908e-03          0.99879       728.696     104.915     0.886963     4.61446e-04     1.80260e-05
   3.60000e+02     2.52571e-01        0.00000         3.94447e-03          0.99869       728.232     104.915     0.885777     5.04023e-04     1.98677e-05
   3.62500e+02     2.76680e-01        0.00000         4.30696e-03          0.99859       727.746     104.915     0.884574     5.50019e-04     2.18795e-05
   3.65000e+02     3.02808e-01        0.00000         4.69841e-03          0.99848       727.237     104.915     0.883354     5.99667e-04     2.40757e-05
   3.67500e+02     3.31100e-01        0.00000         5.12078e-03          0.99836       726.704     104.915     0.882117     6.53214e-04     2.64716e-05
   3.70000e+02     3.61712e-01        0.00000         5.57612e-03          0.99823       726.145     104.915     0.880861     7.10921e-04     2.90837e-05
   3.72500e+02     3.94805e-01        0.00000         6.06662e-03          0.99810       725.561     104.915     0.879587     7.73062e-04     3.19299e-05
   3.75000e+02     4.30554e-01        0.00000         6.59457e-03          0.99796       724.949     104.915     0.878293     8.39927e-04     3.50292e-05
   3.77500e+02     4.69142e-01        0.00000         7.16238e-03          0.99781       724.309     104.915     0.876980     9.11825e-04     3.84022e-05
   3.80000e+02     5.10764e-01        0.00000         7.77261e-03          0.99766       723.639     104.915     0.875646     9.89077e-04     4.20713e-05
   3.82500e+02     5.55626e-01        0.00000         8.42794e-03          0.99749       722.938     104.915     0.874291     1.07203e-03     4.60604e-05
   3.85000e+02     6.03947e-01        0.00000         9.13120e-03          0.99731       722.205     104.915     0.872915     1.16104e-03     5.03953e-05
   3.87500e+02     6.55957e-01        0.00000         9.88537e-03          0.99713       721.438     104.915     0.871516     1.25648e-03     5.51038e-05
   3.90000e+02     7.11901e-01        0.00000         1.06936e-02          0.99693       720.635     104.915     0.870095     1.35877e-03     6.02161e-05
   3.92500e+02     7.72040e-01        0.00000         1.15591e-02          0.99672       719.796     104.915     0.868649     1.46833e-03     6.57645e-05
   3.95000e+02     8.36648e-01        0.00000         1.24855e-02          0.99650       718.919     104.915     0.867179     1.58560e-03     7.17840e-05
   3.97500e+02     9.06017e-01        0.00000         1.34763e-02          0.99627       718.002     104.915     0.865684     1.71106e-03     7.83125e-05
   4.00000e+02     9.80455e-01        0.00000         1.45355e-02          0.99603       717.043     104.915     0.864163     1.84521e-03     8.53908e-05
   4.02500e+02     1.06029e+00        0.00000         1.56671e-02          0.99577       716.040     104.915     0.862615     1.98859e-03     9.30632e-05
   4.05000e+02     1.14587e+00        0.00000         1.68753e-02          0.99550       714.991     104.915     0.861038     2.14175e-03     1.01378e-04
   4.07500e+02     1.23755e+00        0.00000         1.81647e-02          0.99522       713.895     104.915     0.859433     2.30528e-03     1.10386e-04
   4.10000e+02     1.33574e+00        0.00000         1.95400e-02          0.99492       712.749     104.915     0.857798     2.47983e-03     1.20144e-04
   4.12500e+02     1.44085e+00        0.00000         2.10062e-02          0.99461       711.551     104.915     0.856131     2.66604e-03     1.30713e-04
   4.15000e+02     1.55331e+00        0.00000         2.25686e-02          0.99428       710.299     104.915     0.854432     2.86464e-03     1.42160e-04
   4.17500e+02     1.67360e+00        0.00000         2.42327e-02          0.99394       708.989     104.915     0.852700     3.07637e-03     1.54556e-04
   4.20000e+02     1.80221e+00        0.00000         2.60045e-02          0.99357       707.619     104.915     0.850933     3.30203e-03     1.67980e-04
   4.22500e+02     1.93967e+00        0.00000         2.78901e-02          0.99320       706.187     104.915     0.849129     3.54247e-03     1.82517e-04
   4.25000e+02     2.08656e+00        0.00000         2.98961e-02          0.99280       704.689     104.915     0.847288     3.79861e-03     1.98262e-04
   4.27500e+02     2.24347e+00        0.00000         3.20294e-02          0.99238       703.122     104.915     0.845408     4.07140e-03     2.15315e-04
   4.30000e+02     2.41105e+00        0.00000         3.42976e-02          0.99195       701.483     104.915     0.843486     4.36188e-03     2.33790e-04
   4.32500e+02     2.58999e+00        0.00000         3.67082e-02          0.99149       699.768     104.915     0.841522     4.67115e-03     2.53808e-04
   4.35000e+02     2.78103e+00        0.00000         3.92697e-02          0.99101       697.973     104.915     0.839513     5.00040e-03     2.75505e-04
   4.37500e+02     2.98496e+00        0.00000         4.19908e-02          0.99051       696.095     104.915     0.837458     5.35090e-03     2.99028e-04
   4.40000e+02     3.20265e+00        0.00000         4.48810e-02          0.98999       694.128     104.915     0.835353     5.72401e-03     3.24542e-04
   4.42500e+02     3.43499e+00        0.00000         4.79503e-02          0.98945       692.067     104.915     0.833197     6.12120e-03     3.52228e-04
   4.45000e+02     3.68300e+00        0.00000         5.12094e-02          0.98887       689.909     104.915     0.830988     6.54408e-03     3.82285e-04
   4.47500e+02     3.94773e+00        0.00000         5.46696e-02          0.98828       687.647     104.915     0.828721     6.99435e-03     4.14936e-04
   4.50000e+02     4.23035e+00        0.00000         5.83433e-02          0.98765       685.276     104.915     0.826395     7.47388e-03     4.50429e-04
   4.52500e+02     4.53212e+00        0.00000         6.22437e-02          0.98700       682.789     104.915     0.824007     7.98471e-03     4.89040e-04
   4.55000e+02     4.85442e+00        0.00000         6.63850e-02          0.98632       680.178     104.915     0.821552     8.52905e-03     5.31080e-04
   4.57500e+02     5.19873e+00        0.00000         7.07824e-02          0.98561       677.438     104.915     0.819027     9.10933e-03     5.76896e-04
   4.60000e+02     5.56672e+00        0.00000         7.54527e-02          0.98487       674.559     104.915     0.816427     9.72820e-03     6.26880e-04
   4.62500e+02     5.96018e+00        0.00000         8.04139e-02          0.98409       671.532     104.915     0.813748     1.03886e-02     6.81477e-04
   4.65000e+02     6.38111e+00        0.00000         8.56855e-02          0.98328       668.348     104.915     0.810985     1.10938e-02     7.41190e-04
   4.67500e+02     6.83172e+00        0.00000         9.12893e-02          0.98243       664.996     104.915     0.808132     1.18473e-02     8.06596e-04
   4.70000e+02     7.31447e+00        0.00000         9.72487e-02          0.98154       661.464     104.915     0.805183     1.26532e-02     8.78354e-04
   4.72500e+02     7.83211e+00        0.00000         1.03590e-01          0.98061       657.738     104.915     0.802131     1.35161e-02     9.57224e-04
   4.75000e+02     8.38773e+00        0.00000         1.10342e-01          0.97964       653.803     104.915     0.798967     1.44409e-02     1.04409e-03
   4.77500e+02     8.98483e+00        0.00000         1.17537e-01          0.97862       649.644     104.915     0.795683     1.54334e-02     1.13998e-03
   4.80000e+02     9.62739e+00        0.00000         1.25211e-01          0.97755       645.239     104.915     0.792268     1.65002e-02     1.24609e-03
   4.82500e+02     1.03200e+01        0.00000         1.33405e-01          0.97643       640.569     104.915     0.788710     1.76490e-02     1.36387e-03
   4.85000e+02     1.10679e+01        0.00000         1.42166e-01          0.97526       635.608     104.915     0.784997     1.88883e-02     1.49501e-03
   4.87500e+02     1.18772e+01        0.00000         1.51548e-01          0.97402       630.328     104.915     0.781111     2.02286e-02     1.64157e-03
   4.90000e+02     1.27553e+01        0.00000         1.61612e-01          0.97272       624.694     104.915     0.777035     2.16820e-02     1.80606e-03
   4.92500e+02     1.37108e+01        0.00000         1.72433e-01          0.97134       618.667     104.915     0.772745     2.32629e-02     1.99157e-03
   4.95000e+02     1.47542e+01        0.00000         1.84096e-01          0.96989       612.198     104.915     0.768214     2.49891e-02     2.20196e-03
   4.97500e+02     1.58983e+01        0.00000         1.96709e-01          0.96835       605.231     104.915     0.763410     2.68823e-02     2.44215e-03
   5.00000e+02     1.71594e+01        0.00000         2.10400e-01          0.96671       597.691     104.915     0.758289     2.89697e-02     2.71853e-03
   5.02500e+02     1.85581e+01        0.00000         2.25335e-01          0.96496       589.488     104.915     0.752799     3.12867e-02     3.03959e-03
   5.05000e+02     2.01216e+01        0.00000         2.41726e-01          0.96308       580.499     104.915     0.746867     3.38797e-02     3.41694e-03
   5.07500e+02     2.18874e+01        0.00000         2.59862e-01          0.96105       570.563     104.915     0.740398     3.68124e-02     3.86703e-03
   5.10000e+02     2.39088e+01        0.00000         2.80147e-01          0.95884       559.448     104.915     0.733252     4.01765e-02     4.41436e-03
   5.12500e+02     2.62670e+01        0.00000         3.03188e-01          0.95638       546.805     104.915     0.725218     4.41115e-02     5.09770e-03
   5.15000e+02     2.90971e+01        0.00000         3.29981e-01          0.95362       532.060     104.915     0.715943     4.88508e-02     5.98431e-03
   5.17500e+02     3.26580e+01        0.00000         3.62407e-01          0.95037       514.121     104.915     0.704756     5.48420e-02     7.20866e-03
   5.20000e+02     3.75923e+01        0.00000         4.05076e-01          0.94629       490.304     104.915     0.689983     6.32012e-02     9.12120e-03
   5.21560e+02     4.23696e+01        0.00000         4.43997e-01          0.94272       468.311     104.915     0.676340     7.13615e-02     1.12343e-02
   5.22500e+02     4.77539e+01        0.00000         4.85196e-01          0.93913       444.692     104.915     0.661599     8.06424e-02     1.39589e-02
   5.22730e+02     5.22833e+01        0.00000         5.17772e-01          0.93643       425.724     104.915     0.649637     8.85207e-02     1.65639e-02
   5.22730e+02     5.23222e+01        0.00000         5.18044e-01          0.93641       425.565     104.915     0.649536     8.85886e-02     1.65876e-02
   5.22500e+02     5.70662e+01        0.00000         5.50213e-01          0.93386       406.542     104.915     0.637378     9.69119e-02     1.96610e-02
   5.21624e+02     6.30312e+01        0.00000         5.88001e-01          0.93106       383.776     104.915     0.622554     1.07483e-01     2.40835e-02
   5.20000e+02     6.96198e+01        0.00000         6.26504e-01          0.92843       360.043     104.915     0.606700     1.19297e-01     2.97959e-02
   5.17500e+02     7.69310e+01        0.00000         6.65534e-01          0.92607       335.341     104.915     0.589657     1.32579e-01     3.73272e-02
   5.15000e+02     8.28535e+01        0.00000         6.94505e-01          0.92456       316.517     104.915     0.576223     1.43473e-01     4.45097e-02
   5.12500e+02     8.80301e+01        0.00000         7.18020e-01          0.92353       300.888     104.915     0.564725     1.53093e-01     5.17128e-02
   5.10000e+02     9.27192e+01        0.00000         7.37953e-01          0.92282       287.364     104.915     0.554490     1.61887e-01     5.90910e-02
   5.07500e+02     9.70560e+01        0.00000         7.55294e-01          0.92235       275.368     104.915     0.545166     1.70089e-01     6.67328e-02
   5.05000e+02     1.01122e+02        0.00000         7.70645e-01          0.92206       264.553     104.915     0.536543     1.77838e-01     7.46993e-02
   5.02500e+02     1.04969e+02        0.00000         7.84405e-01          0.92194       254.687     104.915     0.528480     1.85225e-01     8.30388e-02
   5.00000e+02     1.08636e+02        0.00000         7.96855e-01          0.92194       245.607     104.915     0.520882     1.92314e-01     9.17930e-02
   4.97500e+02     1.12150e+02        0.00000         8.08203e-01          0.92207       237.194     104.915     0.513676     1.99151e-01     1.01000e-01
   4.95000e+02     1.15530e+02        0.00000         8.18609e-01          0.92229       229.354     104.915     0.506810     2.05772e-01     1.10697e-01
   4.92500e+02     1.18794e+02        0.00000         8.28198e-01          0.92261       222.016     104.915     0.500242     2.12203e-01     1.20919e-01
   4.90000e+02     1.21954e+02        0.00000         8.37069e-01          0.92301       215.121     104.915     0.493937     2.18466e-01     1.31704e-01
   4.87500e+02     1.25020e+02        0.00000         8.45307e-01          0.92348       208.621     104.915     0.487868     2.24579e-01     1.43088e-01
   4.85000e+02     1.28000e+02        0.00000         8.52978e-01          0.92402       202.477     104.915     0.482014     2.30557e-01     1.55112e-01
   4.82500e+02     1.30903e+02        0.00000         8.60141e-01          0.92463       196.655     104.915     0.476356     2.36410e-01     1.67814e-01
   4.80000e+02     1.33734e+02        0.00000         8.66845e-01          0.92530       191.127     104.915     0.470876     2.42149e-01     1.81236e-01
   4.77500e+02     1.36498e+02        0.00000         8.73132e-01          0.92602       185.867     104.915     0.465562     2.47784e-01     1.95424e-01
   4.75000e+02     1.39200e+02        0.00000         8.79039e-01          0.92680       180.854     104.915     0.460402     2.53321e-01     2.10423e-01
   4.72500e+02     1.41844e+02        0.00000         8.84598e-01          0.92762       176.069     104.915     0.455385     2.58766e-01     2.26283e-01
   4.70000e+02     1.44433e+02        0.00000         8.89838e-01          0.92850       171.496     104.915     0.450503     2.64127e-01     2.43055e-01
   4.67500e+02     1.46970e+02        0.00000         8.94783e-01          0.92942       167.119     104.915     0.445747     2.69407e-01     2.60794e-01
   4.65000e+02     1.49457e+02        0.00000         8.99456e-01          0.93038       162.925     104.915     0.441111     2.74610e-01     2.79558e-01
   4.62500e+02     1.51898e+02        0.00000         9.03876e-01          0.93138       158.903     104.915     0.436587     2.79742e-01     2.99409e-01
   4.60000e+02     1.54294e+02        0.00000         9.08062e-01          0.93242       155.041     104.915     0.432170     2.84805e-01     3.20412e-01
   4.57500e+02     1.56647e+02        0.00000         9.12029e-01          0.93350       151.330     104.915     0.427855     2.89803e-01     3.42635e-01
   4.55000e+02     1.58960e+02        0.00000         9.15793e-01          0.93462       147.761     104.915     0.423637     2.94738e-01     3.66153e-01
   4.52500e+02     1.61232e+02        0.00000         9.19367e-01          0.93577       144.326     104.915     0.419512     2.99613e-01     3.91043e-01
   4.50000e+02     1.63467e+02        0.00000         9.22763e-01          0.93695       141.016     104.915     0.415476     3.04431e-01     4.17390e-01
   4.47500e+02     1.65664e+02        0.00000         9.25991e-01          0.93816       137.827     104.915     0.411525     3.09193e-01     4.45280e-01
   4.45000e+02     1.67826e+02        0.00000         9.29062e-01          0.93941       134.750     104.915     0.407656     3.13901e-01     4.74807e-01
   4.42500e+02     1.69953e+02        0.00000         9.31986e-01          0.94068       131.781     104.915     0.403866     3.18558e-01     5.06073e-01
   4.40000e+02     1.72047e+02        0.00000         9.34770e-01          0.94199       128.913     104.915     0.400153     3.23165e-01     5.39183e-01
   4.37500e+02     1.74108e+02        0.00000         9.37423e-01          0.94332       126.143     104.915     0.396512     3.27724e-01     5.74251e-01
   4.35000e+02     1.76138e+02        0.00000         9.39952e-01          0.94468       123.464     104.915     0.392942     3.32236e-01     6.11397e-01
   4.32500e+02     1.78136e+02        0.00000         9.42363e-01          0.94606       120.874     104.915     0.389441     3.36702e-01     6.50751e-01
   4.30000e+02     1.80104e+02        0.00000         9.44664e-01          0.94748       118.367     104.915     0.386006     3.41124e-01     6.92450e-01
   4.27500e+02     1.82043e+02        0.00000         9.46859e-01          0.94891       115.940     104.915     0.382636     3.45502e-01     7.36640e-01
   4.25000e+02     1.83952e+02        0.00000         9.48954e-01          0.95037       113.589     104.915     0.379328     3.49839e-01     7.83477e-01
   4.22500e+02     1.85833e+02        0.00000         9.50955e-01          0.95185       111.312     104.915     0.376081     3.54134e-01     8.33130e-01
   4.20000e+02     1.87687e+02        0.00000         9.52865e-01          0.95336       109.104     104.915     0.372892     3.58389e-01     8.85776e-01
   4.17500e+02     1.89513e+02        0.00000         9.54689e-01          0.95488       106.964     104.915     0.369761     3.62605e-01     9.41605e-01
   4.15443e+02     1.90995e+02        0.00000         9.56128e-01          0.95615       105.252     104.915     0.367230     3.66045e-01     9.90044e-01
   4.15034e+02     1.91287e+02        0.50000         9.56408e-01          0.95641       104.915     104.915     0.366727     3.66727e-01     1.00000e+00
           NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   2.16109e+00     1.51314e+02        0.00000         1.48655e+00          0.90809       195.631     104.915     0.869921     7.63717e-01     6.63553e-02
   1.96318e+00     1.61172e+02        0.00000         1.58168e+00          0.96665       195.369     104.915     0.870322     7.64741e-01     6.61853e-02
   1.76755e+00     1.71671e+02        0.00000         1.68274e+00          1.02893       195.093     104.915     0.870736     7.65797e-01     6.60246e-02
   1.57498e+00     1.82855e+02        0.00000         1.79009e+00          1.09517       194.804     104.915     0.871163     7.66887e-01     6.58741e-02
   1.38624e+00     1.94767e+02        0.00000         1.90410e+00          1.16561       194.502     104.915     0.871603     7.68010e-01     6.57347e-02
   1.20216e+00     2.07456e+02        0.00000         2.02516e+00          1.24051       194.187     104.915     0.872058     7.69167e-01     6.56073e-02
   1.02357e+00     2.20971e+02        0.00000         2.15369e+00          1.32014       193.860     104.915     0.872526     7.70357e-01     6.54927e-02
   8.51323e-01     2.35366e+02        0.00000         2.29014e+00          1.40480       193.519     104.915     0.873010     7.71579e-01     6.53916e-02
   6.86295e-01     2.50699e+02        0.00000         2.43496e+00          1.49478       193.166     104.915     0.873508     7.72835e-01     6.53047e-02
   5.29355e-01     2.67031e+02        0.00000         2.58866e+00          1.59043       192.802     104.915     0.874022     7.74123e-01     6.52328e-02
   3.81384e-01     2.84427e+02        0.00000         2.75175e+00          1.69207       192.427     104.915     0.874553     7.75443e-01     6.51765e-02
   2.43258e-01     3.02956e+02        0.00000         2.92478e+00          1.80007       192.040     104.915     0.875100     7.76795e-01     6.51362e-02
   1.15845e-01     3.22692e+02        0.00000         3.10834e+00          1.91482       191.645     104.915     0.875664     7.78177e-01     6.51125e-02
   0.00000e+00     3.43714e+02        0.00000         3.30305e+00          2.03673       191.240     104.915     0.876246     7.79590e-01     6.51056e-02
  -8.45221e-02     3.61682e+02        0.00000         3.46884e+00          2.14067       190.908     104.915     0.876729     7.80752e-01     6.51126e-02
  -1.60533e-01     3.80589e+02        0.00000         3.64268e+00          2.24980       190.570     104.915     0.877224     7.81934e-01     6.51310e-02
  -2.27619e-01     4.00485e+02        0.00000         3.82497e+00          2.36437       190.229     104.915     0.877731     7.83133e-01     6.51607e-02
  -2.85380e-01     4.21420e+02        0.00000         4.01610e+00          2.48463       189.884     104.915     0.878251     7.84350e-01     6.52018e-02
  -3.33433e-01     4.43450e+02        0.00000         4.21650e+00          2.61086       189.537     104.915     0.878783     7.85585e-01     6.52543e-02
  -3.71413e-01     4.66632e+02        0.00000         4.42660e+00          2.74336       189.187     104.915     0.879329     7.86837e-01     6.53182e-02
  -3.98981e-01     4.91025e+02        0.00000         4.64687e+00          2.88242       188.836     104.915     0.879888     7.88104e-01     6.53933e-02
  -4.15820e-01     5.16693e+02        0.00000         4.87780e+00          3.02836       188.484     104.915     0.880460     7.89387e-01     6.54796e-02
  -4.21630e-01     5.43704e+02        0.00000         5.11990e+00          3.18150       188.132     104.915     0.881045     7.90685e-01     6.55769e-02
  -5.73902e-02     8.12017e+02        0.00000         7.48381e+00          4.68222       185.435     104.915     0.886116     8.01321e-01     6.66961e-02
   1.05907e+00     1.21274e+03        0.00000         1.09193e+01          6.86965       183.093     104.915     0.891926     8.12373e-01     6.83154e-02
   2.85715e+00     1.81122e+03        0.00000         1.59324e+01         10.05767       181.315     104.915     0.898192     8.23298e-01     7.02225e-02
   5.14497e+00     2.70504e+03        0.00000         2.32844e+01         14.71460       180.146     104.915     0.904473     8.33535e-01     7.22226e-02
   7.65744e+00     4.03996e+03        0.00000         3.41190e+01         21.54487       179.494     104.915     0.910304     8.42613e-01     7.41697e-02
   1.01258e+01     6.03364e+03        0.00000         5.01521e+01         31.61057       179.200     104.915     0.915343     8.50240e-01     7.59608e-02
   1.23413e+01     9.01120e+03        0.00000         7.39542e+01         46.51021       179.113     104.915     0.919430     8.56338e-01     7.75246e-02
   1.41882e+01     1.34582e+04        0.00000         1.09372e+02         68.64190       179.124     104.915     0.922580     8.61007e-01     7.88215e-02
   1.56397e+01     2.00996e+04        0.00000         1.62158e+02        101.59384       179.170     104.915     0.924912     8.64456e-01     7.98463e-02
   1.67296e+01     3.00187e+04        0.00000         2.40903e+02        150.72695       179.221     104.915     0.926588     8.66935e-01     8.06224e-02
   1.75206e+01     4.48326e+04        0.00000         3.58438e+02        224.04622       179.264     104.915     0.927766     8.68679e-01     8.11906e-02
   1.80805e+01     6.69572e+04        0.00000         5.33926e+02        333.50382       179.298     104.915     0.928581     8.69887e-01     8.15957e-02
   1.84701e+01     1.00000e+05        0.00000         7.95980e+02        496.94653       179.322     104.915     0.929140     8.70716e-01     8.18792e-02
END

$Env_BP << END
#   Temp        Sat Pres                                                                                    Liq Den      Gas Den           
#    (C)         (bar)        Liq Mole Frac      Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#----------   -----------   ----------------   ---------------   --------------   ---------   ---------   ----------   ----------   -------------
  415.0336      191.287          0.5000            0.95641          0.956408       104.915     104.915     0.366727     0.366727     1.00000e+00
  414.6241      191.580          1.0000            0.95666          0.956686       104.915     104.580     0.367408     0.366225     9.90042e-01
  412.5000      193.084          1.0000            0.95800          0.958095       104.915     102.873     0.370923     0.363664     9.40165e-01
  410.0000      194.830          1.0000            0.95958          0.959685       104.915     100.917     0.375026     0.360696     8.84719e-01
  407.5000      196.551          1.0000            0.96119          0.961203       104.915      99.018     0.379093     0.357779     8.32605e-01
  405.0000      198.247          1.0000            0.96282          0.962653       104.915      97.173     0.383124     0.354913     7.83607e-01
  402.5000      199.917          1.0000            0.96446          0.964038       104.915      95.381     0.387121     0.352095     7.37523e-01
  400.0000      201.563          1.0000            0.96612          0.965361       104.915      93.639     0.391084     0.349325     6.94168e-01
  397.5000      203.185          1.0000            0.96780          0.966623       104.915      91.945     0.395013     0.346602     6.53367e-01
  395.0000      204.782          1.0000            0.96950          0.967828       104.915      90.298     0.398909     0.343925     6.14962e-01
  392.5000      206.356          1.0000            0.97121          0.968978       104.915      88.696     0.402773     0.341293     5.78804e-01
  390.0000      207.906          1.0000            0.97294          0.970074       104.915      87.137     0.406605     0.338704     5.44754e-01
  387.5000      209.432          1.0000            0.97468          0.971119       104.915      85.620     0.410405     0.336157     5.12682e-01
  385.0000      210.936          1.0000            0.97644          0.972115       104.915      84.144     0.414175     0.333653     4.82471e-01
  382.5000      212.416          1.0000            0.97821          0.973064       104.915      82.706     0.417914     0.331189     4.54006e-01
  380.0000      213.874          1.0000            0.98000          0.973966       104.915      81.305     0.421622     0.328766     4.27185e-01
  377.5000      215.310          1.0000            0.98180          0.974824       104.915      79.941     0.425302     0.326381     4.01908e-01
  375.0000      216.722          1.0000            0.98361          0.975640       104.915      78.612     0.428952     0.324035     3.78086e-01
  372.5000      218.113          1.0000            0.98544          0.976413       104.915      77.316     0.432573     0.321726     3.55632e-01
  370.0000      219.481          1.0000            0.98727          0.977147       104.915      76.053     0.436166     0.319454     3.34467e-01
  367.5000      220.828          1.0000            0.98912          0.977842       104.915      74.822     0.439731     0.317218     3.14516e-01
  365.0000      222.153          1.0000            0.99098          0.978499       104.915      73.621     0.443268     0.315018     2.95709e-01
  362.5000      223.455          1.0000            0.99285          0.979119       104.915      72.450     0.446777     0.312852     2.77980e-01
  360.0000      224.737          1.0000            0.99474          0.979704       104.915      71.307     0.450260     0.310720     2.61267e-01
  357.5000      225.996          1.0000            0.99663          0.980254       104.915      70.192     0.453716     0.308622     2.45513e-01
  355.0000      227.235          1.0000            0.99853          0.980770       104.915      69.103     0.457145     0.306556     2.30662e-01
  352.5000      228.452          1.0000            1.00044          0.981253       104.915      68.041     0.460549     0.304522     2.16664e-01
  350.0000      229.647          1.0000            1.00236          0.981704       104.915      67.004     0.463927     0.302519     2.03470e-01
  347.5000      230.822          1.0000            1.00429          0.982124       104.915      65.991     0.467279     0.300547     1.91035e-01
  345.0000      231.975          1.0000            1.00622          0.982513       104.915      65.002     0.470606     0.298606     1.79317e-01
  342.5000      233.107          1.0000            1.00816          0.982872       104.915      64.035     0.473908     0.296694     1.68274e-01
  340.0000      234.218          1.0000            1.01011          0.983201       104.915      63.091     0.477186     0.294811     1.57870e-01
  337.5000      235.308          1.0000            1.01207          0.983502       104.915      62.168     0.480439     0.292957     1.48069e-01
  335.0000      236.377          1.0000            1.01403          0.983775       104.915      61.267     0.483668     0.291131     1.38837e-01
  332.5000      237.426          1.0000            1.01600          0.984020       104.915      60.385     0.486873     0.289333     1.30142e-01
  330.0000      238.453          1.0000            1.01797          0.984237       104.915      59.523     0.490055     0.287561     1.21955e-01
  327.5000      239.460          1.0000            1.01995          0.984428       104.915      58.681     0.493213     0.285816     1.14247e-01
  325.0000      240.445          1.0000            1.02194          0.984592       104.915      57.856     0.496348     0.284097     1.06991e-01
  322.5000      241.410          1.0000            1.02392          0.984731       104.915      57.050     0.499460     0.282404     1.00162e-01
  320.0000      242.354          1.0000            1.02591          0.984843       104.915      56.262     0.502550     0.280736     9.37368e-02
  317.5000      243.277          1.0000            1.02791          0.984931       104.915      55.490     0.505617     0.279093     8.76927e-02
  315.0000      244.180          1.0000            1.02990          0.984993       104.915      54.735     0.508662     0.277474     8.20082e-02
  312.5000      245.061          1.0000            1.03190          0.985030       104.915      53.997     0.511684     0.275879     7.66634e-02
  310.0000      245.922          1.0000            1.03390          0.985043       104.915      53.273     0.514685     0.274308     7.16394e-02
  307.5000      246.762          1.0000            1.03590          0.985032       104.915      52.565     0.517665     0.272760     6.69180e-02
  305.0000      247.581          1.0000            1.03790          0.984997       104.915      51.872     0.520623     0.271234     6.24824e-02
  302.5000      248.379          1.0000            1.03991          0.984937       104.915      51.194     0.523560     0.269731     5.83165e-02
  300.0000      249.157          1.0000            1.04191          0.984854       104.915      50.529     0.526475     0.268249     5.44051e-02
  297.5000      249.913          1.0000            1.04391          0.984747       104.915      49.878     0.529370     0.266790     5.07339e-02
  295.0000      250.648          1.0000            1.04591          0.984616       104.915      49.240     0.532245     0.265351     4.72893e-02
  292.5000      251.363          1.0000            1.04791          0.984462       104.915      48.615     0.535099     0.263934     4.40583e-02
  290.0000      252.056          1.0000            1.04990          0.984285       104.915      48.003     0.537933     0.262537     4.10289e-02
  287.5000      252.729          1.0000            1.05190          0.984084       104.915      47.403     0.540746     0.261160     3.81894e-02
  285.0000      253.380          1.0000            1.05389          0.983860       104.915      46.816     0.543540     0.259803     3.55291e-02
  282.5000      254.010          1.0000            1.05587          0.983613       104.915      46.239     0.546314     0.258466     3.30376e-02
  280.0000      254.619          1.0000            1.05785          0.983343       104.915      45.675     0.549069     0.257148     3.07051e-02
  277.5000      255.207          1.0000            1.05983          0.983049       104.915      45.121     0.551804     0.255850     2.85224e-02
  275.0000      255.773          1.0000            1.06180          0.982731       104.915      44.578     0.554520     0.254570     2.64808e-02
  272.5000      256.318          1.0000            1.06376          0.982391       104.915      44.046     0.557217     0.253309     2.45720e-02
  270.0000      256.842          1.0000            1.06572          0.982027       104.915      43.524     0.559895     0.252065     2.27882e-02
  267.5000      257.344          1.0000            1.06767          0.981639       104.915      43.012     0.562555     0.250840     2.11219e-02
  265.0000      257.824          1.0000            1.06961          0.981227       104.915      42.509     0.565196     0.249633     1.95662e-02
  262.5000      258.283          1.0000            1.07154          0.980792       104.915      42.017     0.567818     0.248443     1.81144e-02
  260.0000      258.720          1.0000            1.07347          0.980333       104.915      41.534     0.570422     0.247270     1.67603e-02
  257.5000      259.135          1.0000            1.07538          0.979850       104.915      41.059     0.573009     0.246114     1.54980e-02
  255.0000      259.528          1.0000            1.07728          0.979342       104.915      40.594     0.575577     0.244975     1.43219e-02
  252.5000      259.900          1.0000            1.07917          0.978810       104.915      40.138     0.578128     0.243853     1.32267e-02
  250.0000      260.249          1.0000            1.08105          0.978253       104.915      39.690     0.580660     0.242747     1.22073e-02
  247.5000      260.576          1.0000            1.08291          0.977672       104.915      39.250     0.583176     0.241657     1.12591e-02
  245.0000      260.880          1.0000            1.08476          0.977065       104.915      38.818     0.585674     0.240583     1.03777e-02
  242.5000      261.162          1.0000            1.08659          0.976433       104.915      38.395     0.588155     0.239525     9.55873e-03
  240.0000      261.422          1.0000            1.08841          0.975775       104.915      37.979     0.590619     0.238482     8.79833e-03
  237.5000      261.659          1.0000            1.09022          0.975091       104.915      37.571     0.593066     0.237455     8.09272e-03
  235.0000      261.873          1.0000            1.09200          0.974381       104.915      37.170     0.595496     0.236443     7.43836e-03
  232.5000      262.064          1.0000            1.09377          0.973645       104.915      36.776     0.597910     0.235446     6.83194e-03
  230.0000      262.233          1.0000            1.09552          0.972881       104.915      36.390     0.600307     0.234464     6.27030e-03
  227.5000      262.378          1.0000            1.09725          0.972091       104.915      36.010     0.602688     0.233496     5.75050e-03
  225.0000      262.500          1.0000            1.09895          0.971272       104.915      35.638     0.605052     0.232543     5.26974e-03
  222.5000      262.598          1.0000            1.10064          0.970426       104.915      35.272     0.607400     0.231605     4.82541e-03
  220.0000      262.673          1.0000            1.10230          0.969551       104.915      34.912     0.609733     0.230680     4.41503e-03
  217.5000      262.725          1.0000            1.10394          0.968648       104.915      34.559     0.612049     0.229770     4.03630e-03
  215.0000      262.752          1.0000            1.10556          0.967715       104.915      34.212     0.614350     0.228873     3.68702e-03
  212.5000      262.756          1.0000            1.10714          0.966752       104.915      33.872     0.616636     0.227990     3.36516e-03
  210.0000      262.735          1.0000            1.10870          0.965759       104.915      33.537     0.618905     0.227121     3.06878e-03
  207.5000      262.690          1.0000            1.11024          0.964736       104.915      33.208     0.621160     0.226265     2.79608e-03
  205.0000      262.621          1.0000            1.11174          0.963681       104.915      32.885     0.623399     0.225423     2.54538e-03
  202.5000      262.527          1.0000            1.11321          0.962595       104.915      32.568     0.625623     0.224594     2.31509e-03
  200.0000      262.408          1.0000            1.11465          0.961476       104.915      32.256     0.627832     0.223778     2.10371e-03
  197.5000      262.264          1.0000            1.11606          0.960324       104.915      31.950     0.630026     0.222975     1.90987e-03
  195.0000      262.095          1.0000            1.11743          0.959139       104.915      31.649     0.632206     0.222184     1.73225e-03
  192.5000      261.901          1.0000            1.11876          0.957920       104.915      31.353     0.634370     0.221407     1.56965e-03
  190.0000      261.681          1.0000            1.12006          0.956666       104.915      31.062     0.636521     0.220641     1.42092e-03
  187.5000      261.436          1.0000            1.12132          0.955377       104.915      30.776     0.638657     0.219889     1.28501e-03
  185.0000      261.165          1.0000            1.12254          0.954052       104.915      30.496     0.640778     0.219148     1.16093e-03
  182.5000      260.867          1.0000            1.12372          0.952690       104.915      30.220     0.642885     0.218420     1.04775e-03
  180.0000      260.543          1.0000            1.12485          0.951291       104.915      29.949     0.644979     0.217704     9.44612e-04
  177.5000      260.193          1.0000            1.12594          0.949853       104.915      29.682     0.647058     0.217000     8.50722e-04
  175.0000      259.816          1.0000            1.12699          0.948377       104.915      29.420     0.649123     0.216307     7.65332e-04
  172.5000      259.412          1.0000            1.12798          0.946861       104.915      29.163     0.651175     0.215626     6.87753e-04
  170.0000      258.981          1.0000            1.12893          0.945304       104.915      28.909     0.653213     0.214957     6.17342e-04
  167.5000      258.523          1.0000            1.12982          0.943706       104.915      28.661     0.655237     0.214299     5.53505e-04
  165.0000      258.037          1.0000            1.13066          0.942066       104.915      28.416     0.657248     0.213653     4.95689e-04
  162.5000      257.523          1.0000            1.13145          0.940383       104.915      28.176     0.659246     0.213017     4.43384e-04
  160.0000      256.981          1.0000            1.13217          0.938656       104.915      27.940     0.661230     0.212393     3.96116e-04
  157.5000      256.410          1.0000            1.13284          0.936884       104.915      27.707     0.663202     0.211780     3.53450e-04
  155.0000      255.811          1.0000            1.13345          0.935066       104.915      27.479     0.665160     0.211177     3.14982e-04
  152.5000      255.183          1.0000            1.13399          0.933201       104.915      27.254     0.667105     0.210585     2.80339e-04
  150.0000      254.526          1.0000            1.13447          0.931288       104.915      27.034     0.669038     0.210003     2.49179e-04
  147.5000      253.840          1.0000            1.13487          0.929326       104.915      26.817     0.670957     0.209432     2.21186e-04
  145.0000      253.124          1.0000            1.13521          0.927314       104.915      26.603     0.672864     0.208871     1.96069e-04
  142.5000      252.378          1.0000            1.13548          0.925251       104.915      26.394     0.674759     0.208320     1.73562e-04
  140.0000      251.602          1.0000            1.13567          0.923136       104.915      26.188     0.676641     0.207779     1.53419e-04
  137.5000      250.795          1.0000            1.13578          0.920967       104.915      25.985     0.678511     0.207248     1.35417e-04
  135.0000      249.958          1.0000            1.13581          0.918744       104.915      25.786     0.680368     0.206726     1.19349e-04
  132.5000      249.089          1.0000            1.13576          0.916464       104.915      25.590     0.682213     0.206213     1.05027e-04
  130.0000      248.189          1.0000            1.13562          0.914128       104.915      25.397     0.684046     0.205710     9.22810e-05
  127.5000      247.257          1.0000            1.13540          0.911733       104.915      25.207     0.685868     0.205216     8.09527e-05
  125.0000      246.294          1.0000            1.13508          0.909278       104.915      25.021     0.687677     0.204731     7.08995e-05
  122.5000      245.298          1.0000            1.13467          0.906762       104.915      24.838     0.689474     0.204254     6.19914e-05
  120.0000      244.269          1.0000            1.13416          0.904183       104.915      24.658     0.691260     0.203786     5.41102e-05
  117.5000      243.208          1.0000            1.13354          0.901540       104.915      24.481     0.693034     0.203327     4.71486e-05
  115.0000      242.113          1.0000            1.13283          0.898832       104.915      24.307     0.694797     0.202875     4.10092e-05
  112.5000      240.984          1.0000            1.13200          0.896056       104.915      24.135     0.696548     0.202431     3.56039e-05
  110.0000      239.821          1.0000            1.13107          0.893212       104.915      23.967     0.698288     0.201995     3.08531e-05
  107.5000      238.624          1.0000            1.13002          0.890297       104.915      23.801     0.700017     0.201566     2.66847e-05
  105.0000      237.393          1.0000            1.12884          0.887310       104.915      23.638     0.701734     0.201144     2.30339e-05
  102.5000      236.126          1.0000            1.12755          0.884250       104.915      23.478     0.703440     0.200730     1.98422e-05
  100.0000      234.824          1.0000            1.12613          0.881114       104.915      23.320     0.705136     0.200321     1.70572e-05
   97.5000      233.485          1.0000            1.12458          0.877900       104.915      23.165     0.706820     0.199920     1.46318e-05
   95.0000      232.111          1.0000            1.12289          0.874608       104.915      23.013     0.708494     0.199524     1.25236e-05
   92.5000      230.700          1.0000            1.12107          0.871234       104.915      22.863     0.710157     0.199134     1.06949e-05
   90.0000      229.252          1.0000            1.11910          0.867777       104.915      22.715     0.711809     0.198749     9.11207e-06
   87.5000      227.766          1.0000            1.11698          0.864236       104.915      22.570     0.713450     0.198370     7.74489e-06
   85.0000      226.243          1.0000            1.11470          0.860607       104.915      22.428     0.715081     0.197995     6.56661e-06
   82.5000      224.682          1.0000            1.11227          0.856889       104.915      22.287     0.716702     0.197625     5.55345e-06
   80.0000      223.081          1.0000            1.10967          0.853079       104.915      22.149     0.718312     0.197259     4.68432e-06
   77.5000      221.442          1.0000            1.10690          0.849177       104.915      22.013     0.719912     0.196896     3.94053e-06
   75.0000      219.763          1.0000            1.10396          0.845178       104.915      21.879     0.721502     0.196536     3.30560e-06
   72.5000      218.044          1.0000            1.10084          0.841081       104.915      21.748     0.723082     0.196179     2.76499e-06
   70.0000      216.285          1.0000            1.09753          0.836883       104.915      21.618     0.724652     0.195825     2.30591e-06
   67.5000      214.485          1.0000            1.09403          0.832583       104.915      21.491     0.726211     0.195472     1.91713e-06
   65.0000      212.643          1.0000            1.09033          0.828177       104.915      21.366     0.727761     0.195120     1.58883e-06
   62.5000      210.760          1.0000            1.08642          0.823663       104.915      21.242     0.729301     0.194769     1.31240e-06
   60.0000      208.834          1.0000            1.08230          0.819039       104.915      21.121     0.730832     0.194417     1.08035e-06
   57.5000      206.865          1.0000            1.07796          0.814302       104.915      21.001     0.732353     0.194065     8.86179e-07
   55.0000      204.854          1.0000            1.07339          0.809449       104.915      20.884     0.733864     0.193711     7.24227e-07
   52.5000      202.798          1.0000            1.06860          0.804477       104.915      20.768     0.735366     0.193356     5.89605e-07
   50.0000      200.699          1.0000            1.06355          0.799384       104.915      20.654     0.736859     0.192997     4.78094e-07
   47.5000      198.554          1.0000            1.05826          0.794167       104.915      20.542     0.738342     0.192634     3.86066e-07
   45.0000      196.364          1.0000            1.05272          0.788823       104.915      20.431     0.739816     0.192267     3.10403e-07
   42.5000      194.129          1.0000            1.04690          0.783350       104.915      20.322     0.741280     0.191894     2.48443e-07
   40.0000      191.847          1.0000            1.04081          0.777744       104.915      20.215     0.742736     0.191514     1.97914e-07
   37.5000      189.519          1.0000            1.03444          0.772002       104.915      20.109     0.744183     0.191126     1.56884e-07
   35.0000      187.143          1.0000            1.02777          0.766123       104.915      20.005     0.745621     0.190728     1.23717e-07
   32.5000      184.720          1.0000            1.02081          0.760102       104.915      19.902     0.747050     0.190320     9.70343e-08
   30.0000      182.248          1.0000            1.01352          0.753938       104.915      19.801     0.748470     0.189900     7.56731e-08
   27.5000      179.727          1.0000            1.00592          0.747627       104.915      19.701     0.749882     0.189466     5.86611e-08
   25.0000      177.157          1.0000            0.99798          0.741167       104.915      19.603     0.751285     0.189016     4.51869e-08
   22.5000      174.538          1.0000            0.98970          0.734555       104.915      19.506     0.752679     0.188548     3.45760e-08
   20.0000      171.867          1.0000            0.98107          0.727790       104.915      19.410     0.754065     0.188061     2.62706e-08
   17.5000      169.147          1.0000            0.97206          0.720868       104.915      19.316     0.755443     0.187552     1.98114e-08
   15.0000      166.375          1.0000            0.96268          0.713788       104.915      19.223     0.756812     0.187018     1.48221e-08
   12.5000      163.551          1.0000            0.95291          0.706549       104.915      19.131     0.758173     0.186457     1.09960e-08
   10.0000      160.675          1.0000            0.94274          0.699149       104.915      19.040     0.759526     0.185865     8.08425e-09
    7.5000      157.746          1.0000            0.93215          0.691588       104.915      18.950     0.760871     0.185238     5.88650e-09
    5.0000      154.765          1.0000            0.92113          0.683865       104.915      18.862     0.762208     0.184573     4.24211e-09
    2.5000      151.730          1.0000            0.90967          0.675981       104.915      18.774     0.763538     0.183866     3.02326e-09
    2.1611      151.314          1.0000            0.90809          0.674900       104.915      18.762     0.763717     0.183766     2.88497e-09
END

set output "Figures/Env_002_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:4.5e+02] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_002_LogP_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set title "Swelling of Oil Sample 2"
show title

$Expt << END
#                                       Sat Pres (barg)      Density (g/cm3)      Liq Vol Frac           C45+ K-Value
# Stg      Rel Moles Inj      Feed       Expt    Calc         Expt     Calc       Expt    Calc         Expt        Calc
#-----   ----------------   -------   ------------------   ------------------   ----------------   ------------------------
    1         0.0000          NaN       232.42  231.65          NaN  0.70783     1.0000  1.0000            NaN  2.5147e-05
    2         0.2987          M23       272.47  289.01      0.65300  0.66860     1.0000  1.0000            NaN  8.1847e-04
    3         1.1834          M54       397.42  395.94      0.58000  0.59464     1.0000  1.0000            NaN  1.5125e-01
    4         1.5641          M61       425.37  428.28      0.56100  0.57442     1.0000  1.0000     1.0000e+00  5.6061e-01
    5         1.8818          M65       444.86  453.87      0.54700  0.56122     0.0000  0.0000     1.0000e+00  4.8228e-01
    6         3.5662          M78       586.05  574.30      0.49600  0.52212     0.0000  0.0000            NaN  6.2467e-02
END
set xlabel "Relative Moles Injected"
set ylabel "Saturation Pressure (barg)"
set output "Figures/Expt_010_SATP_vs_RMI_1.pdf"
plot [0:*][*<0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_010_DEN_vs_RMI_1.pdf"
plot [0:*][0:*] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"

set title "CCE of 0% Solvent/Oil Mixture"
show title

$Expt << END
#          Pres      Gas Vol Frac (%)
# Stg     (barg)       Expt    Calc
#-----   --------   ------------------
    1     212.01       8.100   4.925
    2     206.64       8.700   6.307
    3     200.84       9.600   7.822
    4     194.43      10.600   9.528
    5     186.16      15.200  11.789
    6     151.68      23.800  22.157
    7     128.24      31.000  30.383
    8     111.83      36.500  36.875
    9      99.84      42.100  42.059
END
set xlabel "Pressure (barg)"
set ylabel "Gas Volume Fraction (%)"
set output "Figures/Expt_011_GVF_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"

set title "CCE of 23% Solvent/Oil Mixture"
show title

$Expt << END
#          Pres      Gas Vol Frac (%)
# Stg     (barg)       Expt    Calc
#-----   --------   ------------------
    1     241.66      16.500  11.925
    2     235.39      17.000  13.459
    3     214.43      20.800  18.667
    4     155.82      34.600  34.976
    5     101.63      50.400  54.170
    6      75.84      60.900  65.032
    7      60.67      68.900  71.896
END
set xlabel "Pressure (barg)"
set ylabel "Gas Volume Fraction (%)"
set output "Figures/Expt_012_GVF_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"

set title "CCE of 54% Solvent/Oil Mixture"
show title

$Expt << END
#          Pres      Gas Vol Frac (%)
# Stg     (barg)       Expt     Calc
#-----   --------   ------------------
    1     395.21     11.9000   0.6582
    2     390.93     14.3000   4.0529
    3     381.35     20.6000   9.6434
    4     367.90     23.1000  15.0006
    5     343.36     26.4000  21.5500
    6     255.66     37.8000  36.9418
    7     197.88     48.5000  47.6347
    8     147.34     59.8000  59.2922
    9     118.73     64.8000  66.9587
END
set xlabel "Pressure (barg)"
set ylabel "Gas Volume Fraction (%)"
set output "Figures/Expt_013_GVF_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"

set title "CCE of 61% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres      Gas Vol Frac (%)
#  Stg     (barg)       Expt    Calc
#------   --------   ------------------
     1     421.96      11.400  16.760
     2     415.75      16.900  21.937
     3     410.10      20.700  24.545
     4     398.86      24.800  27.698
     5     388.45      30.300  29.644
     6     378.18      30.400  31.170
     7     368.52      34.000  32.417
     8     350.18      34.100  34.532
     9     333.36      37.200  36.343
    10     270.76      43.500  43.306
    11     218.22      48.800  50.676
END
set xlabel "Pressure (barg)"
set ylabel "Gas Volume Fraction (%)"
set output "Figures/Expt_014_GVF_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"

set title "CCE of 65% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres      Gas Vol Frac (%)           C6+ x                C6+ y             C6+ K-Value
#  Stg     (barg)       Expt    Calc         Expt     Calc        Expt     Calc        Expt     Calc
#------   --------   ------------------   ------------------   ------------------   ------------------
     1     438.02      59.700  63.187          NaN  0.18073         NaN  0.13584         NaN  0.75158
     2     431.89      60.000  56.649          NaN  0.18267         NaN  0.13017         NaN  0.71259
     3     426.23      59.000  52.804          NaN  0.18487         NaN  0.12540         NaN  0.67829
     4     420.10      57.400  50.027          NaN  0.18749         NaN  0.12066         NaN  0.64355
     5     414.24      56.500  48.212          NaN  0.19015         NaN  0.11649         NaN  0.61263
     6     402.86      53.900  46.065          NaN  0.19557         NaN  0.10918         NaN  0.55824
     7     381.69      51.500  44.501          NaN  0.20635         NaN  0.09754         NaN  0.47268
     8     362.39      50.600  44.349          NaN  0.21684         NaN  0.08840         NaN  0.40765
     9     314.68      51.500  46.167          NaN  0.24567         NaN  0.06921         NaN  0.28172
    10     259.10      54.100  50.610          NaN  0.28564         NaN  0.05039         NaN  0.17640
    11     222.29      57.500  54.941      0.29830  0.31731     0.04220  0.03964     0.14150  0.12492
END
set xlabel "Pressure (barg)"
set ylabel "Gas Volume Fraction (%)"
set output "Figures/Expt_015_GVF_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Liquid C6+ Mole Fraction"
set output "Figures/Expt_015_X-C6+_vs_PRES_1.pdf"
plot [*<0:*][0:1] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Gas C6+ Mole Fraction"
set output "Figures/Expt_015_Y-C6+_vs_PRES_1.pdf"
plot [*<0:*][0:1] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"
set ylabel "Equilibrium C6+ K-Value"
set output "Figures/Expt_015_K-C6+_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 2:9 with points title "Expt", $Expt using 2:10 with lines title "Calc"

set title "CCE of 78% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres      Gas Vol Frac (%)
#  Stg     (barg)       Expt    Calc
#------   --------   ------------------
     1     442.09      81.500  91.665
     2     430.92      80.200  89.928
     3     419.41      79.200  87.512
     4     398.03      74.600  82.545
     5     377.83      73.600  78.574
     6     350.39      71.100  74.656
     7     284.41      68.200  70.520
     8     239.94      69.800  70.786
     9     210.36      71.100  72.211
    10     188.43      68.400  73.946
END
set xlabel "Pressure (barg)"
set ylabel "Gas Volume Fraction (%)"
set output "Figures/Expt_016_GVF_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"

set title "Phase Envelope for Oil Sample 3"
show title

$Env_DP << END
#    Temp         Sat Pres                                                                                     Liq Den       Gas Den             
#    (C)           (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#-----------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   44.21237     1.00000e-13        0.00000         2.88294e-15          1.00000       737.351     100.742     0.969281     3.81787e-16     9.04629e-18
   45.00000     1.17427e-13        0.00000         3.37737e-15          1.00000       737.351     100.742     0.969167     4.47213e-16     1.05839e-17
   47.50000     1.94348e-13        0.00000         5.54823e-15          1.00000       737.351     100.742     0.968802     7.34389e-16     1.73174e-17
   50.00000     3.18750e-13        0.00000         9.03265e-15          1.00000       737.351     100.742     0.968435     1.19515e-15     2.80873e-17
   52.50000     5.18172e-13        0.00000         1.45767e-14          1.00000       737.351     100.742     0.968065     1.92797e-15     4.51667e-17
   55.00000     8.35116e-13        0.00000         2.33226e-14          1.00000       737.351     100.742     0.967691     3.08355e-15     7.20280e-17
   57.50000     1.33462e-12        0.00000         3.70052e-14          1.00000       737.351     100.742     0.967315     4.89065e-15     1.13932e-16
   60.00000     2.11543e-12        0.00000         5.82372e-14          1.00000       737.351     100.742     0.966935     7.69369e-15     1.78786e-16
   62.50000     3.32621e-12        0.00000         9.09237e-14          1.00000       737.351     100.742     0.966552     1.20071e-14     2.78390e-16
   65.00000     5.18914e-12        0.00000         1.40856e-13          1.00000       737.351     100.742     0.966166     1.85936e-14     4.30210e-16
   67.50000     8.03373e-12        0.00000         2.16557e-13          1.00000       737.351     100.742     0.965777     2.85750e-14     6.59924e-16
   70.00000     1.23450e-11        0.00000         3.30481e-13          1.00000       737.351     100.742     0.965385     4.35898e-14     1.00501e-15
   72.50000     1.88319e-11        0.00000         5.00697e-13          1.00000       737.351     100.742     0.964990     6.60137e-14     1.51977e-15
   75.00000     2.85231e-11        0.00000         7.53230e-13          1.00000       737.351     100.742     0.964591     9.92676e-14     2.28240e-15
   77.50000     4.29015e-11        0.00000         1.12532e-12          1.00000       737.351     100.742     0.964189     1.48243e-13     3.40469e-15
   80.00000     6.40897e-11        0.00000         1.66990e-12          1.00000       737.351     100.742     0.963784     2.19890e-13     5.04551e-15
   82.50000     9.51068e-11        0.00000         2.46169e-12          1.00000       737.351     100.742     0.963375     3.24015e-13     7.42911e-15
   85.00000     1.40219e-10        0.00000         3.60555e-12          1.00000       737.350     100.742     0.962963     4.74372e-13     1.08702e-14
   87.50000     2.05418e-10        0.00000         5.24770e-12          1.00000       737.350     100.742     0.962548     6.90126e-13     1.58075e-14
   90.00000     2.99064e-10        0.00000         7.59075e-12          1.00000       737.350     100.742     0.962129     9.97827e-13     2.28496e-14
   92.50000     4.32760e-10        0.00000         1.09139e-11          1.00000       737.350     100.742     0.961707     1.43403e-12     3.28352e-14
   95.00000     6.22506e-10        0.00000         1.55994e-11          1.00000       737.350     100.742     0.961282     2.04878e-12     4.69138e-14
   97.50000     8.90245e-10        0.00000         2.21681e-11          1.00000       737.350     100.742     0.960853     2.91020e-12     6.66525e-14
  100.00000     1.26590e-09        0.00000         3.13252e-11          1.00000       737.350     100.742     0.960420     4.11048e-12     9.41762e-14
  102.50000     1.79006e-09        0.00000         4.40209e-11          1.00000       737.349     100.742     0.959984     5.77378e-12     1.32350e-13
  105.00000     2.51746e-09        0.00000         6.15280e-11          1.00000       737.349     100.742     0.959544     8.06631e-12     1.85020e-13
  107.50000     3.52157e-09        0.00000         8.55433e-11          1.00000       737.349     100.742     0.959101     1.12095e-11     2.57317e-13
  110.00000     4.90048e-09        0.00000         1.18317e-10          1.00000       737.349     100.742     0.958654     1.54970e-11     3.56062e-13
  112.50000     6.78447e-09        0.00000         1.62818e-10          1.00000       737.348     100.742     0.958203     2.13157e-11     4.90267e-13
  115.00000     9.34575e-09        0.00000         2.22947e-10          1.00000       737.348     100.742     0.957748     2.91737e-11     6.71793e-13
  117.50000     1.28109e-08        0.00000         3.03798e-10          1.00000       737.347     100.742     0.957290     3.97345e-11     9.16173e-13
  120.00000     1.74764e-08        0.00000         4.12001e-10          1.00000       737.347     100.742     0.956828     5.38606e-11     1.24366e-12
  122.50000     2.37290e-08        0.00000         5.56138e-10          1.00000       737.346     100.742     0.956362     7.26683e-11     1.68054e-12
  125.00000     3.20701e-08        0.00000         7.47275e-10          1.00000       737.346     100.742     0.955893     9.75955e-11     2.26078e-12
  127.50000     4.31474e-08        0.00000         9.99613e-10          1.00000       737.345     100.742     0.955419     1.30487e-10     3.02810e-12
  130.00000     5.77940e-08        0.00000         1.33130e-09          1.00000       737.344     100.742     0.954942     1.73697e-10     4.03852e-12
  132.50000     7.70767e-08        0.00000         1.76542e-09          1.00000       737.343     100.742     0.954460     2.30223e-10     5.36354e-12
  135.00000     1.02356e-07        0.00000         2.33126e-09          1.00000       737.342     100.742     0.953975     3.03857e-10     7.09406e-12
  137.50000     1.35359e-07        0.00000         3.06574e-09          1.00000       737.341     100.742     0.953486     3.99386e-10     9.34517e-12
  140.00000     1.78272e-07        0.00000         4.01532e-09          1.00000       737.340     100.742     0.952992     5.22821e-10     1.22620e-11
  142.50000     2.33849e-07        0.00000         5.23815e-09          1.00000       737.338     100.742     0.952495     6.81686e-10     1.60271e-11
  145.00000     3.05546e-07        0.00000         6.80680e-09          1.00000       737.337     100.742     0.951993     8.85363e-10     2.08688e-11
  147.50000     3.97686e-07        0.00000         8.81145e-09          1.00000       737.335     100.742     0.951487     1.14550e-09     2.70719e-11
  150.00000     5.15653e-07        0.00000         1.13638e-08          1.00000       737.333     100.742     0.950977     1.47652e-09     3.49909e-11
  152.50000     6.66133e-07        0.00000         1.46016e-08          1.00000       737.331     100.742     0.950462     1.89620e-09     4.50643e-11
  155.00000     8.57393e-07        0.00000         1.86945e-08          1.00000       737.329     100.742     0.949944     2.42639e-09     5.78340e-11
  157.50000     1.09963e-06        0.00000         2.38499e-08          1.00000       737.326     100.742     0.949420     3.09384e-09     7.39664e-11
  160.00000     1.40535e-06        0.00000         3.03217e-08          1.00000       737.323     100.742     0.948893     3.93118e-09     9.42790e-11
  162.50000     1.78989e-06        0.00000         3.84183e-08          1.00000       737.320     100.742     0.948361     4.97813e-09     1.19771e-10
  165.00000     2.27196e-06        0.00000         4.85143e-08          1.00000       737.317     100.742     0.947825     6.28282e-09     1.51661e-10
  167.50000     2.87430e-06        0.00000         6.10626e-08          1.00000       737.313     100.742     0.947284     7.90341e-09     1.91427e-10
  170.00000     3.62449e-06        0.00000         7.66093e-08          1.00000       737.309     100.742     0.946738     9.90997e-09     2.40863e-10
  172.50000     4.55587e-06        0.00000         9.58104e-08          1.00000       737.305     100.742     0.946188     1.23867e-08     3.02131e-10
  175.00000     5.70861e-06        0.00000         1.19452e-07          1.00000       737.300     100.742     0.945633     1.54342e-08     3.77839e-10
  177.50000     7.13099e-06        0.00000         1.48474e-07          1.00000       737.295     100.742     0.945074     1.91729e-08     4.71114e-10
  180.00000     8.88079e-06        0.00000         1.83995e-07          1.00000       737.289     100.742     0.944509     2.37458e-08     5.85703e-10
  182.50000     1.10271e-05        0.00000         2.27345e-07          1.00000       737.283     100.742     0.943940     2.93228e-08     7.26078e-10
  185.00000     1.36521e-05        0.00000         2.80096e-07          1.00000       737.276     100.742     0.943366     3.61051e-08     8.97564e-10
  187.50000     1.68535e-05        0.00000         3.44109e-07          1.00000       737.269     100.742     0.942787     4.43297e-08     1.10649e-09
  190.00000     2.07469e-05        0.00000         4.21574e-07          1.00000       737.261     100.742     0.942203     5.42760e-08     1.36034e-09
  192.50000     2.54690e-05        0.00000         5.15064e-07          1.00000       737.252     100.742     0.941614     6.62719e-08     1.66797e-09
  195.00000     3.11808e-05        0.00000         6.27595e-07          1.00000       737.243     100.742     0.941020     8.07009e-08     2.03981e-09
  197.50000     3.80713e-05        0.00000         7.62690e-07          1.00000       737.233     100.742     0.940421     9.80114e-08     2.48813e-09
  200.00000     4.63623e-05        0.00000         9.24458e-07          1.00000       737.222     100.742     0.939817     1.18725e-07     3.02730e-09
  202.50000     5.63129e-05        0.00000         1.11768e-06          1.00000       737.210     100.742     0.939207     1.43449e-07     3.67415e-09
  205.00000     6.82253e-05        0.00000         1.34789e-06          1.00000       737.197     100.742     0.938592     1.72885e-07     4.44832e-09
  207.50000     8.24510e-05        0.00000         1.62151e-06          1.00000       737.184     100.742     0.937971     2.07847e-07     5.37269e-09
  210.00000     9.93981e-05        0.00000         1.94594e-06          1.00000       737.169     100.742     0.937345     2.49272e-07     6.47381e-09
  212.50000     1.19539e-04        0.00000         2.32971e-06          1.00000       737.153     100.742     0.936714     2.98238e-07     7.78250e-09
  215.00000     1.43419e-04        0.00000         2.78264e-06          1.00000       737.136     100.742     0.936077     3.55985e-07     9.33441e-09
  217.50000     1.71668e-04        0.00000         3.31595e-06          1.00000       737.117     100.742     0.935434     4.23932e-07     1.11707e-08
  220.00000     2.05009e-04        0.00000         3.94251e-06          1.00000       737.098     100.742     0.934786     5.03699e-07     1.33386e-08
  222.50000     2.44271e-04        0.00000         4.67700e-06          1.00000       737.076     100.742     0.934131     5.97138e-07     1.58929e-08
  225.00000     2.90405e-04        0.00000         5.53615e-06          1.00000       737.054     100.742     0.933471     7.06354e-07     1.88958e-08
  227.50000     3.44497e-04        0.00000         6.53899e-06          1.00000       737.029     100.742     0.932805     8.33737e-07     2.24189e-08
  230.00000     4.07783e-04        0.00000         7.70707e-06          1.00000       737.003     100.742     0.932133     9.81998e-07     2.65441e-08
  232.50000     4.81673e-04        0.00000         9.06483e-06          0.99999       736.975     100.742     0.931454     1.15420e-06     3.13646e-08
  235.00000     5.67766e-04        0.00000         1.06399e-05          0.99999       736.945     100.742     0.930770     1.35381e-06     3.69865e-08
  237.50000     6.67873e-04        0.00000         1.24633e-05          0.99999       736.914     100.742     0.930079     1.58471e-06     4.35305e-08
  240.00000     7.84044e-04        0.00000         1.45702e-05          0.99999       736.879     100.742     0.929381     1.85130e-06     5.11333e-08
  242.50000     9.18592e-04        0.00000         1.69998e-05          0.99999       736.843     100.742     0.928678     2.15848e-06     5.99498e-08
  245.00000     1.07412e-03        0.00000         1.97963e-05          0.99999       736.804     100.742     0.927967     2.51177e-06     7.01550e-08
  247.50000     1.25357e-03        0.00000         2.30091e-05          0.99999       736.763     100.742     0.927250     2.91732e-06     8.19464e-08
  250.00000     1.46022e-03        0.00000         2.66932e-05          0.99999       736.719     100.742     0.926526     3.38200e-06     9.55463e-08
  252.50000     1.69776e-03        0.00000         3.09103e-05          0.99998       736.672     100.742     0.925796     3.91347e-06     1.11205e-07
  255.00000     1.97031e-03        0.00000         3.57288e-05          0.99998       736.622     100.742     0.925058     4.52024e-06     1.29203e-07
  257.50000     2.28247e-03        0.00000         4.12247e-05          0.99998       736.569     100.742     0.924313     5.21174e-06     1.49855e-07
  260.00000     2.63938e-03        0.00000         4.74824e-05          0.99998       736.513     100.742     0.923561     5.99845e-06     1.73513e-07
  262.50000     3.04674e-03        0.00000         5.45954e-05          0.99997       736.453     100.742     0.922802     6.89195e-06     2.00570e-07
  265.00000     3.51089e-03        0.00000         6.26670e-05          0.99997       736.389     100.742     0.922036     7.90503e-06     2.31465e-07
  267.50000     4.03886e-03        0.00000         7.18112e-05          0.99997       736.321     100.742     0.921261     9.05177e-06     2.66687e-07
  270.00000     4.63843e-03        0.00000         8.21538e-05          0.99996       736.250     100.742     0.920480     1.03477e-05     3.06780e-07
  272.50000     5.31820e-03        0.00000         9.38329e-05          0.99996       736.174     100.742     0.919690     1.18099e-05     3.52347e-07
  275.00000     6.08767e-03        0.00000         1.07001e-04          0.99995       736.093     100.742     0.918892     1.34571e-05     4.04058e-07
  277.50000     6.95731e-03        0.00000         1.21823e-04          0.99994       736.008     100.742     0.918087     1.53097e-05     4.62655e-07
  280.00000     7.93861e-03        0.00000         1.38483e-04          0.99994       735.917     100.742     0.917273     1.73902e-05     5.28958e-07
  282.50000     9.04423e-03        0.00000         1.57181e-04          0.99993       735.822     100.742     0.916451     1.97232e-05     6.03875e-07
  285.00000     1.02880e-02        0.00000         1.78133e-04          0.99992       735.720     100.742     0.915620     2.23353e-05     6.88404e-07
  287.50000     1.16852e-02        0.00000         2.01578e-04          0.99991       735.613     100.742     0.914781     2.52557e-05     7.83649e-07
  290.00000     1.32524e-02        0.00000         2.27774e-04          0.99990       735.500     100.742     0.913933     2.85160e-05     8.90821e-07
  292.50000     1.50077e-02        0.00000         2.57003e-04          0.99989       735.380     100.742     0.913076     3.21507e-05     1.01125e-06
  295.00000     1.69710e-02        0.00000         2.89570e-04          0.99988       735.254     100.742     0.912210     3.61971e-05     1.14641e-06
  297.50000     1.91638e-02        0.00000         3.25806e-04          0.99987       735.121     100.742     0.911335     4.06956e-05     1.29790e-06
  300.00000     2.16096e-02        0.00000         3.66070e-04          0.99985       734.980     100.742     0.910450     4.56899e-05     1.46748e-06
  302.50000     2.43339e-02        0.00000         4.10750e-04          0.99983       734.831     100.742     0.909555     5.12274e-05     1.65706e-06
  305.00000     2.73644e-02        0.00000         4.60266e-04          0.99982       734.675     100.742     0.908651     5.73590e-05     1.86877e-06
  307.50000     3.07310e-02        0.00000         5.15069e-04          0.99980       734.509     100.742     0.907736     6.41396e-05     2.10489e-06
  310.00000     3.44662e-02        0.00000         5.75647e-04          0.99978       734.335     100.742     0.906811     7.16286e-05     2.36793e-06
  312.50000     3.86050e-02        0.00000         6.42523e-04          0.99975       734.152     100.742     0.905876     7.98895e-05     2.66062e-06
  315.00000     4.31855e-02        0.00000         7.16263e-04          0.99973       733.959     100.742     0.904930     8.89908e-05     2.98593e-06
  317.50000     4.82485e-02        0.00000         7.97471e-04          0.99970       733.755     100.742     0.903973     9.90057e-05     3.34711e-06
  320.00000     5.38380e-02        0.00000         8.86797e-04          0.99967       733.541     100.742     0.903005     1.10013e-04     3.74767e-06
  322.50000     6.00014e-02        0.00000         9.84937e-04          0.99964       733.316     100.742     0.902026     1.22097e-04     4.19144e-06
  325.00000     6.67897e-02        0.00000         1.09263e-03          0.99960       733.079     100.742     0.901035     1.35347e-04     4.68255e-06
  327.50000     7.42578e-02        0.00000         1.21069e-03          0.99957       732.830     100.742     0.900032     1.49860e-04     5.22551e-06
  330.00000     8.24642e-02        0.00000         1.33994e-03          0.99953       732.568     100.742     0.899017     1.65738e-04     5.82520e-06
  332.50000     9.14721e-02        0.00000         1.48131e-03          0.99948       732.293     100.742     0.897989     1.83092e-04     6.48689e-06
  335.00000     1.01349e-01        0.00000         1.63576e-03          0.99944       732.004     100.742     0.896949     2.02037e-04     7.21629e-06
  337.50000     1.12167e-01        0.00000         1.80432e-03          0.99939       731.700     100.742     0.895895     2.22698e-04     8.01960e-06
  340.00000     1.24003e-01        0.00000         1.98808e-03          0.99933       731.381     100.742     0.894829     2.45207e-04     8.90349e-06
  342.50000     1.36940e-01        0.00000         2.18822e-03          0.99927       731.046     100.742     0.893748     2.69705e-04     9.87518e-06
  345.00000     1.51066e-01        0.00000         2.40597e-03          0.99921       730.695     100.742     0.892654     2.96341e-04     1.09425e-05
  347.50000     1.66474e-01        0.00000         2.64264e-03          0.99914       730.326     100.742     0.891545     3.25273e-04     1.21138e-05
  350.00000     1.83265e-01        0.00000         2.89964e-03          0.99907       729.939     100.742     0.890422     3.56671e-04     1.33982e-05
  352.50000     2.01545e-01        0.00000         3.17843e-03          0.99899       729.533     100.742     0.889283     3.90711e-04     1.48055e-05
  355.00000     2.21429e-01        0.00000         3.48058e-03          0.99891       729.108     100.742     0.888129     4.27582e-04     1.63463e-05
  357.50000     2.43035e-01        0.00000         3.80776e-03          0.99882       728.662     100.742     0.886959     4.67486e-04     1.80320e-05
  360.00000     2.66494e-01        0.00000         4.16171e-03          0.99873       728.194     100.742     0.885772     5.10633e-04     1.98748e-05
  362.50000     2.91940e-01        0.00000         4.54428e-03          0.99863       727.704     100.742     0.884569     5.57247e-04     2.18880e-05
  365.00000     3.19520e-01        0.00000         4.95744e-03          0.99853       727.191     100.742     0.883349     6.07565e-04     2.40858e-05
  367.50000     3.49386e-01        0.00000         5.40325e-03          0.99841       726.654     100.742     0.882111     6.61838e-04     2.64837e-05
  370.00000     3.81702e-01        0.00000         5.88390e-03          0.99829       726.090     100.742     0.880854     7.20330e-04     2.90981e-05
  372.50000     4.16641e-01        0.00000         6.40168e-03          0.99817       725.501     100.742     0.879579     7.83321e-04     3.19469e-05
  375.00000     4.54387e-01        0.00000         6.95903e-03          0.99803       724.883     100.742     0.878285     8.51105e-04     3.50493e-05
  377.50000     4.95133e-01        0.00000         7.55851e-03          0.99789       724.237     100.742     0.876971     9.23996e-04     3.84261e-05
  380.00000     5.39087e-01        0.00000         8.20281e-03          0.99773       723.560     100.742     0.875636     1.00232e-03     4.20995e-05
  382.50000     5.86466e-01        0.00000         8.89479e-03          0.99757       722.852     100.742     0.874280     1.08643e-03     4.60937e-05
  385.00000     6.37504e-01        0.00000         9.63744e-03          0.99740       722.111     100.742     0.872903     1.17669e-03     5.04345e-05
  387.50000     6.92444e-01        0.00000         1.04339e-02          0.99722       721.336     100.742     0.871503     1.27349e-03     5.51501e-05
  390.00000     7.51547e-01        0.00000         1.12875e-02          0.99704       720.525     100.742     0.870080     1.37724e-03     6.02704e-05
  392.50000     8.15088e-01        0.00000         1.22018e-02          0.99684       719.676     100.742     0.868634     1.48837e-03     6.58283e-05
  395.00000     8.83361e-01        0.00000         1.31805e-02          0.99662       718.788     100.742     0.867162     1.60735e-03     7.18589e-05
  397.50000     9.56674e-01        0.00000         1.42273e-02          0.99640       717.860     100.742     0.865666     1.73464e-03     7.84003e-05
  400.00000     1.03536e+00        0.00000         1.53465e-02          0.99617       716.888     100.742     0.864143     1.87078e-03     8.54937e-05
  402.50000     1.11975e+00        0.00000         1.65423e-02          0.99592       715.872     100.742     0.862592     2.01629e-03     9.31836e-05
  405.00000     1.21024e+00        0.00000         1.78193e-02          0.99566       714.809     100.742     0.861014     2.17175e-03     1.01518e-04
  407.50000     1.30720e+00        0.00000         1.91823e-02          0.99539       713.698     100.742     0.859406     2.33777e-03     1.10550e-04
  410.00000     1.41106e+00        0.00000         2.06363e-02          0.99510       712.535     100.742     0.857768     2.51500e-03     1.20336e-04
  412.50000     1.52225e+00        0.00000         2.21866e-02          0.99480       711.319     100.742     0.856099     2.70411e-03     1.30937e-04
  415.00000     1.64126e+00        0.00000         2.38389e-02          0.99449       710.047     100.742     0.854397     2.90584e-03     1.42421e-04
  417.50000     1.76857e+00        0.00000         2.55991e-02          0.99415       708.716     100.742     0.852661     3.12095e-03     1.54860e-04
  420.00000     1.90472e+00        0.00000         2.74736e-02          0.99381       707.324     100.742     0.850891     3.35027e-03     1.68334e-04
  422.50000     2.05029e+00        0.00000         2.94688e-02          0.99344       705.867     100.742     0.849083     3.59466e-03     1.82929e-04
  425.00000     2.20587e+00        0.00000         3.15919e-02          0.99306       704.343     100.742     0.847238     3.85506e-03     1.98741e-04
  427.50000     2.37212e+00        0.00000         3.38503e-02          0.99266       702.747     100.742     0.845352     4.13248e-03     2.15873e-04
  430.00000     2.54972e+00        0.00000         3.62519e-02          0.99224       701.078     100.742     0.843426     4.42796e-03     2.34438e-04
  432.50000     2.73943e+00        0.00000         3.88050e-02          0.99181       699.329     100.742     0.841456     4.74266e-03     2.54562e-04
  435.00000     2.94204e+00        0.00000         4.15186e-02          0.99135       697.499     100.742     0.839441     5.07779e-03     2.76381e-04
  437.50000     3.15841e+00        0.00000         4.44022e-02          0.99087       695.581     100.742     0.837378     5.43467e-03     3.00046e-04
  440.00000     3.38945e+00        0.00000         4.74659e-02          0.99037       693.573     100.742     0.835266     5.81472e-03     3.25726e-04
  442.50000     3.63617e+00        0.00000         5.07204e-02          0.98984       691.467     100.742     0.833102     6.21946e-03     3.53604e-04
  445.00000     3.89963e+00        0.00000         5.41772e-02          0.98930       689.260     100.742     0.830883     6.65055e-03     3.83885e-04
  447.50000     4.18100e+00        0.00000         5.78489e-02          0.98873       686.945     100.742     0.828607     7.10979e-03     4.16798e-04
  450.00000     4.48154e+00        0.00000         6.17486e-02          0.98813       684.517     100.742     0.826270     7.59911e-03     4.52597e-04
  452.50000     4.80263e+00        0.00000         6.58906e-02          0.98750       681.967     100.742     0.823869     8.12064e-03     4.91565e-04
  455.00000     5.14578e+00        0.00000         7.02904e-02          0.98685       679.290     100.742     0.821400     8.67670e-03     5.34023e-04
  457.50000     5.51261e+00        0.00000         7.49647e-02          0.98617       676.476     100.742     0.818860     9.26985e-03     5.80330e-04
  460.00000     5.90494e+00        0.00000         7.99316e-02          0.98546       673.518     100.742     0.816243     9.90287e-03     6.30891e-04
  462.50000     6.32477e+00        0.00000         8.52107e-02          0.98472       670.405     100.742     0.813546     1.05789e-02     6.86168e-04
  465.00000     6.77428e+00        0.00000         9.08237e-02          0.98394       667.127     100.742     0.810762     1.13013e-02     7.46684e-04
  467.50000     7.25594e+00        0.00000         9.67943e-02          0.98313       663.672     100.742     0.807885     1.20739e-02     8.13040e-04
  470.00000     7.77247e+00        0.00000         1.03148e-01          0.98228       660.027     100.742     0.804910     1.29011e-02     8.85927e-04
  472.50000     8.32696e+00        0.00000         1.09915e-01          0.98139       656.177     100.742     0.801828     1.37876e-02     9.66144e-04
  475.00000     8.92286e+00        0.00000         1.17126e-01          0.98046       652.107     100.742     0.798630     1.47388e-02     1.05462e-03
  477.50000     9.56413e+00        0.00000         1.24818e-01          0.97948       647.798     100.742     0.795308     1.57611e-02     1.15244e-03
  480.00000     1.02553e+01        0.00000         1.33031e-01          0.97846       643.228     100.742     0.791850     1.68616e-02     1.26090e-03
  482.50000     1.10015e+01        0.00000         1.41812e-01          0.97739       638.375     100.742     0.788243     1.80484e-02     1.38153e-03
  485.00000     1.18088e+01        0.00000         1.51212e-01          0.97626       633.210     100.742     0.784473     1.93313e-02     1.51615e-03
  487.50000     1.26844e+01        0.00000         1.61295e-01          0.97508       627.700     100.742     0.780521     2.07216e-02     1.66700e-03
  490.00000     1.36368e+01        0.00000         1.72130e-01          0.97383       621.809     100.742     0.776367     2.22328e-02     1.83682e-03
  492.50000     1.46760e+01        0.00000         1.83804e-01          0.97252       615.489     100.742     0.771986     2.38812e-02     2.02902e-03
  495.00000     1.58146e+01        0.00000         1.96418e-01          0.97112       608.687     100.742     0.767347     2.56871e-02     2.24792e-03
  497.50000     1.70682e+01        0.00000         2.10098e-01          0.96965       601.333     100.742     0.762412     2.76754e-02     2.49907e-03
  500.00000     1.84565e+01        0.00000         2.25002e-01          0.96807       593.342     100.742     0.757132     2.98782e-02     2.78981e-03
  502.50000     2.00055e+01        0.00000         2.41331e-01          0.96639       584.602     100.742     0.751443     3.23376e-02     3.13007e-03
  505.00000     2.17500e+01        0.00000         2.59356e-01          0.96457       574.964     100.742     0.745258     3.51105e-02     3.53378e-03
  507.50000     2.37395e+01        0.00000         2.79449e-01          0.96261       564.219     100.742     0.738457     3.82774e-02     4.02129e-03
  510.00000     2.60474e+01        0.00000         3.02160e-01          0.96044       552.058     100.742     0.730858     4.19590e-02     4.62420e-03
  512.50000     2.87928e+01        0.00000         3.28365e-01          0.95802       537.988     100.742     0.722166     4.63505e-02     5.39561e-03
  515.00000     3.21925e+01        0.00000         3.59633e-01          0.95524       521.119     100.742     0.711849     5.18094e-02     6.43652e-03
  517.50000     3.67357e+01        0.00000         3.99464e-01          0.95185       499.457     100.742     0.698699     5.91439e-02     7.98515e-03
  520.00000     4.42891e+01        0.00000         4.61006e-01          0.94695       465.483     100.742     0.678117     7.14478e-02     1.09995e-02
  520.95394     5.35636e+01        0.00000         5.29160e-01          0.94202       426.922     100.742     0.654515     8.67576e-02     1.55647e-02
  520.95394     5.36138e+01        0.00000         5.29508e-01          0.94200       426.722     100.742     0.654391     8.68412e-02     1.55923e-02
  520.00000     6.38454e+01        0.00000         5.96039e-01          0.93777       387.837     100.742     0.629962     1.04006e-01     2.19665e-02
  517.50000     7.39076e+01        0.00000         6.53545e-01          0.93470       352.971     100.742     0.607204     1.21174e-01     2.99181e-02
  515.00000     8.09441e+01        0.00000         6.89537e-01          0.93315       330.418     100.742     0.591899     1.33353e-01     3.66909e-02
  512.50000     8.68214e+01        0.00000         7.17159e-01          0.93221       312.655     100.742     0.579447     1.43636e-01     4.32585e-02
  510.00000     9.20288e+01        0.00000         7.39899e-01          0.93163       297.693     100.742     0.568643     1.52830e-01     4.98751e-02
  507.50000     9.67830e+01        0.00000         7.59324e-01          0.93132       284.638     100.742     0.558952     1.61294e-01     5.66589e-02
  505.00000     1.01203e+02        0.00000         7.76301e-01          0.93121       273.000     100.742     0.550081     1.69223e-01     6.36810e-02
  502.50000     1.05362e+02        0.00000         7.91374e-01          0.93125       262.468     100.742     0.541848     1.76736e-01     7.09921e-02
  500.00000     1.09309e+02        0.00000         8.04910e-01          0.93143       252.836     100.742     0.534131     1.83915e-01     7.86328e-02
  497.50000     1.13079e+02        0.00000         8.17172e-01          0.93172       243.953     100.742     0.526845     1.90815e-01     8.66381e-02
  495.00000     1.16698e+02        0.00000         8.28357e-01          0.93212       235.708     100.742     0.519925     1.97480e-01     9.50407e-02
  492.50000     1.20186e+02        0.00000         8.38617e-01          0.93260       228.016     100.742     0.513322     2.03940e-01     1.03871e-01
  490.00000     1.23557e+02        0.00000         8.48072e-01          0.93317       220.808     100.742     0.506999     2.10221e-01     1.13161e-01
  487.50000     1.26826e+02        0.00000         8.56819e-01          0.93380       214.029     100.742     0.500924     2.16343e-01     1.22941e-01
  485.00000     1.30000e+02        0.00000         8.64938e-01          0.93451       207.634     100.742     0.495073     2.22322e-01     1.33242e-01
  482.50000     1.33090e+02        0.00000         8.72495e-01          0.93527       201.585     100.742     0.489424     2.28172e-01     1.44097e-01
  480.00000     1.36101e+02        0.00000         8.79548e-01          0.93610       195.850     100.742     0.483960     2.33903e-01     1.55540e-01
  477.50000     1.39040e+02        0.00000         8.86143e-01          0.93698       190.400     100.742     0.478667     2.39525e-01     1.67606e-01
  475.00000     1.41913e+02        0.00000         8.92324e-01          0.93791       185.213     100.742     0.473530     2.45047e-01     1.80331e-01
  472.50000     1.44722e+02        0.00000         8.98126e-01          0.93889       180.268     100.742     0.468540     2.50475e-01     1.93755e-01
  470.00000     1.47473e+02        0.00000         9.03580e-01          0.93991       175.545     100.742     0.463686     2.55815e-01     2.07918e-01
  467.50000     1.50168e+02        0.00000         9.08715e-01          0.94098       171.030     100.742     0.458960     2.61074e-01     2.22862e-01
  465.00000     1.52811e+02        0.00000         9.13556e-01          0.94208       166.707     100.742     0.454354     2.66255e-01     2.38634e-01
  462.50000     1.55404e+02        0.00000         9.18125e-01          0.94323       162.564     100.742     0.449861     2.71362e-01     2.55280e-01
  460.00000     1.57950e+02        0.00000         9.22441e-01          0.94442       158.588     100.742     0.445477     2.76401e-01     2.72852e-01
  457.50000     1.60450e+02        0.00000         9.26522e-01          0.94564       154.771     100.742     0.441194     2.81373e-01     2.91403e-01
  455.00000     1.62907e+02        0.00000         9.30385e-01          0.94689       151.101     100.742     0.437008     2.86282e-01     3.10990e-01
  452.50000     1.65322e+02        0.00000         9.34044e-01          0.94818       147.571     100.742     0.432916     2.91131e-01     3.31672e-01
  450.00000     1.67697e+02        0.00000         9.37513e-01          0.94950       144.173     100.742     0.428911     2.95922e-01     3.53513e-01
  447.50000     1.70033e+02        0.00000         9.40802e-01          0.95085       140.898     100.742     0.424992     3.00657e-01     3.76580e-01
  445.00000     1.72331e+02        0.00000         9.43924e-01          0.95223       137.741     100.742     0.421154     3.05339e-01     4.00946e-01
  442.50000     1.74594e+02        0.00000         9.46889e-01          0.95364       134.695     100.742     0.417394     3.09969e-01     4.26685e-01
  440.00000     1.76821e+02        0.00000         9.49706e-01          0.95508       131.755     100.742     0.413710     3.14549e-01     4.53879e-01
  437.50000     1.79014e+02        0.00000         9.52383e-01          0.95655       128.915     100.742     0.410098     3.19081e-01     4.82614e-01
  435.00000     1.81173e+02        0.00000         9.54929e-01          0.95804       126.170     100.742     0.406556     3.23566e-01     5.12980e-01
  432.50000     1.83300e+02        0.00000         9.57350e-01          0.95955       123.517     100.742     0.403082     3.28006e-01     5.45075e-01
  430.00000     1.85396e+02        0.00000         9.59654e-01          0.96109       120.949     100.742     0.399674     3.32402e-01     5.79000e-01
  427.50000     1.87460e+02        0.00000         9.61846e-01          0.96265       118.465     100.742     0.396329     3.36755e-01     6.14867e-01
  425.00000     1.89494e+02        0.00000         9.63933e-01          0.96424       116.059     100.742     0.393046     3.41066e-01     6.52791e-01
  422.50000     1.91498e+02        0.00000         9.65920e-01          0.96585       113.728     100.742     0.389822     3.45336e-01     6.92896e-01
  420.00000     1.93474e+02        0.00000         9.67812e-01          0.96748       111.469     100.742     0.386657     3.49566e-01     7.35315e-01
  417.50000     1.95420e+02        0.00000         9.69613e-01          0.96913       109.280     100.742     0.383548     3.53758e-01     7.80188e-01
  415.00000     1.97339e+02        0.00000         9.71329e-01          0.97080       107.156     100.742     0.380493     3.57912e-01     8.27665e-01
  412.50000     1.99230e+02        0.00000         9.72962e-01          0.97249       105.096     100.742     0.377492     3.62028e-01     8.77907e-01
  410.00000     2.01094e+02        0.00000         9.74518e-01          0.97420       103.096     100.742     0.374544     3.66108e-01     9.31084e-01
  407.50000     2.02931e+02        0.00000         9.75998e-01          0.97593       101.155     100.742     0.371646     3.70153e-01     9.87372e-01
  407.38440     2.03015e+02        0.00000         9.76065e-01          0.97601       101.067     100.742     0.371514     3.70339e-01     9.90046e-01
  406.95867     2.03325e+02        0.50000         9.76309e-01          0.97631       100.742     100.742     0.371024     3.71024e-01     1.00000e+00
        NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
    3.87095     1.63516e+02        0.00000         1.57950e+00          0.94723       193.110     100.742     0.867955     7.55034e-01     6.55769e-02
    3.51466     1.77417e+02        0.00000         1.71178e+00          1.02699       192.774     100.742     0.868575     7.56577e-01     6.52031e-02
    3.16607     1.92500e+02        0.00000         1.85480e+00          1.11335       192.412     100.742     0.869213     7.58174e-01     6.48534e-02
    2.82717     2.08865e+02        0.00000         2.00937e+00          1.20686       192.025     100.742     0.869870     7.59825e-01     6.45299e-02
    2.50000     2.26621e+02        0.00000         2.17639e+00          1.30807       191.611     100.742     0.870547     7.61530e-01     6.42345e-02
    2.30169     2.38522e+02        0.00000         2.28793e+00          1.37578       191.339     100.742     0.870981     7.62626e-01     6.40643e-02
    2.10931     2.51047e+02        0.00000         2.40498e+00          1.44691       191.057     100.742     0.871424     7.63742e-01     6.39062e-02
    1.92340     2.64230e+02        0.00000         2.52781e+00          1.52166       190.765     100.742     0.871875     7.64879e-01     6.37607e-02
    1.74445     2.78105e+02        0.00000         2.65669e+00          1.60019       190.465     100.742     0.872335     7.66036e-01     6.36280e-02
    1.57298     2.92709e+02        0.00000         2.79190e+00          1.68268       190.156     100.742     0.872803     7.67213e-01     6.35084e-02
    1.40949     3.08080e+02        0.00000         2.93374e+00          1.76934       189.838     100.742     0.873281     7.68409e-01     6.34021e-02
    1.25448     3.24258e+02        0.00000         3.08253e+00          1.86036       189.513     100.742     0.873769     7.69624e-01     6.33095e-02
    1.10842     3.41285e+02        0.00000         3.23859e+00          1.95596       189.180     100.742     0.874266     7.70858e-01     6.32306e-02
    0.97180     3.59207e+02        0.00000         3.40226e+00          2.05636       188.841     100.742     0.874774     7.72110e-01     6.31656e-02
    0.84507     3.78070e+02        0.00000         3.57390e+00          2.16179       188.495     100.742     0.875292     7.73379e-01     6.31146e-02
    0.72868     3.97923e+02        0.00000         3.75389e+00          2.27250       188.144     100.742     0.875820     7.74666e-01     6.30777e-02
    0.62306     4.18819e+02        0.00000         3.94262e+00          2.38873       187.787     100.742     0.876360     7.75970e-01     6.30548e-02
    0.52861     4.40812e+02        0.00000         4.14052e+00          2.51077       187.427     100.742     0.876911     7.77289e-01     6.30459e-02
    0.44572     4.63960e+02        0.00000         4.34801e+00          2.63888       187.063     100.742     0.877473     7.78625e-01     6.30510e-02
    0.37475     4.88324e+02        0.00000         4.56556e+00          2.77337       186.696     100.742     0.878047     7.79975e-01     6.30699e-02
    0.31603     5.13967e+02        0.00000         4.79364e+00          2.91453       186.327     100.742     0.878633     7.81339e-01     6.31025e-02
    0.26988     5.40956e+02        0.00000         5.03276e+00          3.06270       185.956     100.742     0.879231     7.82717e-01     6.31485e-02
    0.23657     5.69363e+02        0.00000         5.28346e+00          3.21820       185.586     100.742     0.879841     7.84108e-01     6.32077e-02
    0.21635     5.99262e+02        0.00000         5.54629e+00          3.38140       185.215     100.742     0.880464     7.85510e-01     6.32799e-02
    0.20944     6.30730e+02        0.00000         5.82184e+00          3.55266       184.846     100.742     0.881099     7.86924e-01     6.33648e-02
    0.60620     9.31293e+02        0.00000         8.40848e+00          5.16558       182.148     100.742     0.886330     7.97958e-01     6.43852e-02
    1.78544     1.37508e+03        0.00000         1.21267e+01          7.48945       179.854     100.742     0.892160     8.09143e-01     6.59213e-02
    3.63283     2.03036e+03        0.00000         1.74953e+01         10.83951       178.132     100.742     0.898295     8.19974e-01     6.77558e-02
    5.93180     2.99788e+03        0.00000         2.52861e+01         15.68206       176.993     100.742     0.904322     8.29959e-01     6.96990e-02
    8.41467     4.42647e+03        0.00000         3.66450e+01         22.71140       176.332     100.742     0.909836     8.38711e-01     7.16065e-02
   10.82659     6.53582e+03        0.00000         5.32706e+01         32.96234       176.001     100.742     0.914557     8.46012e-01     7.33713e-02
   12.97851     9.65035e+03        0.00000         7.76790e+01         47.97378       175.863     100.742     0.918374     8.51834e-01     7.49181e-02
   14.77040     1.42491e+04        0.00000         1.13592e+02         70.02706       175.824     100.742     0.921318     8.56297e-01     7.62056e-02
   16.18273     2.10392e+04        0.00000         1.66511e+02        102.49592       175.827     100.742     0.923507     8.59610e-01     7.72277e-02
   17.24962     3.10650e+04        0.00000         2.44560e+02        150.36314       175.845     100.742     0.925091     8.62007e-01     7.80071e-02
   18.03031     4.58685e+04        0.00000         3.59735e+02        220.98442       175.864     100.742     0.926215     8.63709e-01     7.85825e-02
   18.58845     6.77263e+04        0.00000         5.29743e+02        325.21776       175.880     100.742     0.927001     8.64900e-01     7.89968e-02
   18.98090     1.00000e+05        0.00000         7.80730e+02        479.09204       175.893     100.742     0.927545     8.65726e-01     7.92897e-02
END

$Env_BP << END
#   Temp        Sat Pres                                                                                    Liq Den      Gas Den           
#    (C)         (bar)        Liq Mole Frac      Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#----------   -----------   ----------------   ---------------   --------------   ---------   ---------   ----------   ----------   -------------
  406.9587      203.325          0.5000            0.97631          0.976309       100.742     100.742     0.371024     0.371024     1.00000e+00
  406.5329      203.634          1.0000            0.97661          0.976552       100.742     100.419     0.371708     0.370535     9.90047e-01
  405.0000      204.742          1.0000            0.97768          0.977408       100.742      99.270     0.374162     0.368797     9.55125e-01
  402.5000      206.526          1.0000            0.97944          0.978749       100.742      97.438     0.378138     0.365996     9.00813e-01
  400.0000      208.285          1.0000            0.98123          0.980025       100.742      95.658     0.382079     0.363243     8.49638e-01
  397.5000      210.018          1.0000            0.98302          0.981239       100.742      93.928     0.385988     0.360536     8.01402e-01
  395.0000      211.727          1.0000            0.98484          0.982393       100.742      92.246     0.389864     0.357873     7.55924e-01
  392.5000      213.410          1.0000            0.98667          0.983489       100.742      90.610     0.393708     0.355255     7.13034e-01
  390.0000      215.069          1.0000            0.98851          0.984531       100.742      89.018     0.397521     0.352679     6.72577e-01
  387.5000      216.704          1.0000            0.99037          0.985519       100.742      87.469     0.401303     0.350146     6.34404e-01
  385.0000      218.314          1.0000            0.99225          0.986456       100.742      85.961     0.405054     0.347654     5.98381e-01
  382.5000      219.900          1.0000            0.99414          0.987344       100.742      84.493     0.408776     0.345202     5.64380e-01
  380.0000      221.463          1.0000            0.99604          0.988185       100.742      83.064     0.412468     0.342789     5.32282e-01
  377.5000      223.002          1.0000            0.99795          0.988980       100.742      81.671     0.416130     0.340415     5.01977e-01
  375.0000      224.518          1.0000            0.99988          0.989730       100.742      80.314     0.419764     0.338079     4.73359e-01
  372.5000      226.011          1.0000            1.00182          0.990439       100.742      78.992     0.423370     0.335779     4.46334e-01
  370.0000      227.480          1.0000            1.00377          0.991105       100.742      77.703     0.426948     0.333516     4.20808e-01
  367.5000      228.926          1.0000            1.00573          0.991732       100.742      76.447     0.430498     0.331289     3.96698e-01
  365.0000      230.350          1.0000            1.00770          0.992320       100.742      75.222     0.434022     0.329097     3.73923e-01
  362.5000      231.751          1.0000            1.00968          0.992871       100.742      74.027     0.437518     0.326939     3.52409e-01
  360.0000      233.129          1.0000            1.01167          0.993385       100.742      72.861     0.440988     0.324814     3.32084e-01
  357.5000      234.485          1.0000            1.01368          0.993864       100.742      71.724     0.444431     0.322722     3.12883e-01
  355.0000      235.819          1.0000            1.01569          0.994308       100.742      70.614     0.447849     0.320663     2.94744e-01
  352.5000      237.130          1.0000            1.01771          0.994719       100.742      69.530     0.451241     0.318635     2.77607e-01
  350.0000      238.419          1.0000            1.01973          0.995097       100.742      68.472     0.454608     0.316639     2.61417e-01
  347.5000      239.685          1.0000            1.02177          0.995443       100.742      67.440     0.457950     0.314673     2.46124e-01
  345.0000      240.930          1.0000            1.02381          0.995757       100.742      66.431     0.461267     0.312737     2.31678e-01
  342.5000      242.152          1.0000            1.02586          0.996042       100.742      65.446     0.464560     0.310830     2.18032e-01
  340.0000      243.353          1.0000            1.02792          0.996296       100.742      64.483     0.467829     0.308952     2.05143e-01
  337.5000      244.531          1.0000            1.02998          0.996522       100.742      63.542     0.471073     0.307103     1.92971e-01
  335.0000      245.688          1.0000            1.03205          0.996718       100.742      62.623     0.474294     0.305282     1.81477e-01
  332.5000      246.822          1.0000            1.03413          0.996887       100.742      61.725     0.477492     0.303487     1.70623e-01
  330.0000      247.935          1.0000            1.03620          0.997028       100.742      60.846     0.480667     0.301720     1.60376e-01
  327.5000      249.026          1.0000            1.03829          0.997142       100.742      59.987     0.483818     0.299979     1.50703e-01
  325.0000      250.095          1.0000            1.04037          0.997229       100.742      59.147     0.486947     0.298265     1.41573e-01
  322.5000      251.142          1.0000            1.04247          0.997290       100.742      58.326     0.490054     0.296575     1.32957e-01
  320.0000      252.168          1.0000            1.04456          0.997325       100.742      57.522     0.493138     0.294911     1.24827e-01
  317.5000      253.171          1.0000            1.04666          0.997334       100.742      56.736     0.496200     0.293272     1.17158e-01
  315.0000      254.153          1.0000            1.04875          0.997319       100.742      55.967     0.499241     0.291656     1.09924e-01
  312.5000      255.113          1.0000            1.05086          0.997278       100.742      55.214     0.502260     0.290065     1.03102e-01
  310.0000      256.051          1.0000            1.05296          0.997212       100.742      54.477     0.505258     0.288497     9.66710e-02
  307.5000      256.968          1.0000            1.05506          0.997122       100.742      53.756     0.508234     0.286952     9.06088e-02
  305.0000      257.862          1.0000            1.05716          0.997008       100.742      53.050     0.511189     0.285429     8.48958e-02
  302.5000      258.735          1.0000            1.05927          0.996869       100.742      52.358     0.514124     0.283929     7.95135e-02
  300.0000      259.585          1.0000            1.06137          0.996707       100.742      51.681     0.517038     0.282451     7.44438e-02
  297.5000      260.414          1.0000            1.06347          0.996521       100.742      51.018     0.519932     0.280994     6.96701e-02
  295.0000      261.221          1.0000            1.06557          0.996311       100.742      50.368     0.522806     0.279559     6.51762e-02
  292.5000      262.006          1.0000            1.06767          0.996077       100.742      49.732     0.525659     0.278144     6.09470e-02
  290.0000      262.768          1.0000            1.06976          0.995820       100.742      49.108     0.528493     0.276750     5.69682e-02
  287.5000      263.509          1.0000            1.07185          0.995540       100.742      48.497     0.531307     0.275376     5.32261e-02
  285.0000      264.227          1.0000            1.07394          0.995236       100.742      47.898     0.534101     0.274022     4.97078e-02
  282.5000      264.923          1.0000            1.07602          0.994908       100.742      47.311     0.536876     0.272688     4.64010e-02
  280.0000      265.597          1.0000            1.07810          0.994558       100.742      46.736     0.539632     0.271373     4.32941e-02
  277.5000      266.249          1.0000            1.08017          0.994183       100.742      46.172     0.542370     0.270077     4.03762e-02
  275.0000      266.878          1.0000            1.08224          0.993786       100.742      45.619     0.545088     0.268799     3.76366e-02
  272.5000      267.484          1.0000            1.08430          0.993364       100.742      45.076     0.547787     0.267540     3.50656e-02
  270.0000      268.068          1.0000            1.08635          0.992920       100.742      44.544     0.550469     0.266300     3.26538e-02
  267.5000      268.630          1.0000            1.08840          0.992451       100.742      44.023     0.553131     0.265077     3.03921e-02
  265.0000      269.169          1.0000            1.09043          0.991959       100.742      43.511     0.555776     0.263872     2.82722e-02
  262.5000      269.685          1.0000            1.09246          0.991442       100.742      43.009     0.558403     0.262684     2.62861e-02
  260.0000      270.178          1.0000            1.09447          0.990902       100.742      42.517     0.561011     0.261513     2.44261e-02
  257.5000      270.648          1.0000            1.09648          0.990338       100.742      42.033     0.563602     0.260359     2.26850e-02
  255.0000      271.096          1.0000            1.09848          0.989749       100.742      41.559     0.566176     0.259222     2.10560e-02
  252.5000      271.520          1.0000            1.10046          0.989135       100.742      41.094     0.568732     0.258102     1.95327e-02
  250.0000      271.920          1.0000            1.10243          0.988497       100.742      40.637     0.571270     0.256997     1.81088e-02
  247.5000      272.298          1.0000            1.10439          0.987833       100.742      40.189     0.573792     0.255909     1.67786e-02
  245.0000      272.652          1.0000            1.10633          0.987144       100.742      39.749     0.576297     0.254836     1.55365e-02
  242.5000      272.982          1.0000            1.10826          0.986430       100.742      39.317     0.578784     0.253779     1.43774e-02
  240.0000      273.289          1.0000            1.11017          0.985690       100.742      38.893     0.581255     0.252738     1.32962e-02
  237.5000      273.572          1.0000            1.11206          0.984924       100.742      38.476     0.583710     0.251712     1.22884e-02
  235.0000      273.831          1.0000            1.11394          0.984132       100.742      38.067     0.586148     0.250700     1.13494e-02
  232.5000      274.067          1.0000            1.11580          0.983312       100.742      37.666     0.588569     0.249704     1.04752e-02
  230.0000      274.277          1.0000            1.11764          0.982466       100.742      37.271     0.590975     0.248722     9.66158e-03
  227.5000      274.464          1.0000            1.11946          0.981592       100.742      36.884     0.593364     0.247755     8.90497e-03
  225.0000      274.626          1.0000            1.12125          0.980691       100.742      36.503     0.595737     0.246803     8.20178e-03
  222.5000      274.764          1.0000            1.12303          0.979761       100.742      36.130     0.598095     0.245864     7.54864e-03
  220.0000      274.877          1.0000            1.12478          0.978803       100.742      35.763     0.600437     0.244940     6.94240e-03
  217.5000      274.965          1.0000            1.12651          0.977815       100.742      35.402     0.602763     0.244029     6.38006e-03
  215.0000      275.028          1.0000            1.12822          0.976799       100.742      35.048     0.605074     0.243132     5.85879e-03
  212.5000      275.066          1.0000            1.12989          0.975752       100.742      34.699     0.607370     0.242249     5.37594e-03
  210.0000      275.079          1.0000            1.13154          0.974675       100.742      34.357     0.609650     0.241379     4.92898e-03
  207.5000      275.066          1.0000            1.13316          0.973567       100.742      34.021     0.611915     0.240523     4.51555e-03
  205.0000      275.027          1.0000            1.13476          0.972427       100.742      33.691     0.614166     0.239679     4.13342e-03
  202.5000      274.963          1.0000            1.13632          0.971256       100.742      33.366     0.616401     0.238849     3.78047e-03
  200.0000      274.873          1.0000            1.13785          0.970052       100.742      33.047     0.618622     0.238032     3.45474e-03
  197.5000      274.756          1.0000            1.13934          0.968814       100.742      32.733     0.620828     0.237228     3.15435e-03
  195.0000      274.613          1.0000            1.14080          0.967543       100.742      32.425     0.623020     0.236436     2.87755e-03
  192.5000      274.444          1.0000            1.14223          0.966238       100.742      32.122     0.625197     0.235657     2.62270e-03
  190.0000      274.248          1.0000            1.14362          0.964898       100.742      31.824     0.627360     0.234890     2.38826e-03
  187.5000      274.024          1.0000            1.14497          0.963522       100.742      31.532     0.629509     0.234136     2.17276e-03
  185.0000      273.774          1.0000            1.14628          0.962110       100.742      31.244     0.631644     0.233393     1.97485e-03
  182.5000      273.497          1.0000            1.14754          0.960660       100.742      30.961     0.633764     0.232663     1.79324e-03
  180.0000      273.192          1.0000            1.14877          0.959173       100.742      30.683     0.635871     0.231945     1.62676e-03
  177.5000      272.859          1.0000            1.14995          0.957648       100.742      30.409     0.637965     0.231239     1.47426e-03
  175.0000      272.498          1.0000            1.15108          0.956083       100.742      30.140     0.640044     0.230545     1.33472e-03
  172.5000      272.109          1.0000            1.15217          0.954478       100.742      29.876     0.642110     0.229862     1.20714e-03
  170.0000      271.692          1.0000            1.15320          0.952832       100.742      29.616     0.644163     0.229191     1.09061e-03
  167.5000      271.245          1.0000            1.15419          0.951144       100.742      29.360     0.646202     0.228532     9.84288e-04
  165.0000      270.770          1.0000            1.15512          0.949413       100.742      29.109     0.648228     0.227883     8.87364e-04
  162.5000      270.266          1.0000            1.15600          0.947639       100.742      28.862     0.650241     0.227246     7.99101e-04
  160.0000      269.733          1.0000            1.15682          0.945820       100.742      28.618     0.652241     0.226620     7.18808e-04
  157.5000      269.170          1.0000            1.15758          0.943956       100.742      28.379     0.654227     0.226006     6.45841e-04
  155.0000      268.577          1.0000            1.15828          0.942045       100.742      28.144     0.656202     0.225402     5.79603e-04
  152.5000      267.954          1.0000            1.15891          0.940087       100.742      27.913     0.658163     0.224808     5.19539e-04
  150.0000      267.300          1.0000            1.15948          0.938080       100.742      27.686     0.660111     0.224226     4.65135e-04
  147.5000      266.616          1.0000            1.15998          0.936024       100.742      27.462     0.662048     0.223654     4.15912e-04
  145.0000      265.900          1.0000            1.16042          0.933916       100.742      27.242     0.663971     0.223093     3.71429e-04
  142.5000      265.154          1.0000            1.16078          0.931757       100.742      27.026     0.665882     0.222542     3.31277e-04
  140.0000      264.376          1.0000            1.16106          0.929545       100.742      26.813     0.667781     0.222001     2.95077e-04
  137.5000      263.566          1.0000            1.16127          0.927278       100.742      26.604     0.669668     0.221470     2.62481e-04
  135.0000      262.724          1.0000            1.16140          0.924955       100.742      26.398     0.671543     0.220949     2.33166e-04
  132.5000      261.849          1.0000            1.16145          0.922576       100.742      26.195     0.673406     0.220438     2.06836e-04
  130.0000      260.942          1.0000            1.16141          0.920139       100.742      25.996     0.675256     0.219937     1.83218e-04
  127.5000      260.002          1.0000            1.16128          0.917642       100.742      25.800     0.677095     0.219446     1.62060e-04
  125.0000      259.028          1.0000            1.16106          0.915083       100.742      25.607     0.678923     0.218963     1.43133e-04
  122.5000      258.021          1.0000            1.16075          0.912463       100.742      25.418     0.680738     0.218491     1.26223e-04
  120.0000      256.979          1.0000            1.16034          0.909778       100.742      25.231     0.682542     0.218027     1.11139e-04
  117.5000      255.903          1.0000            1.15983          0.907028       100.742      25.048     0.684335     0.217572     9.77013e-05
  115.0000      254.792          1.0000            1.15922          0.904211       100.742      24.867     0.686116     0.217126     8.57489e-05
  112.5000      253.647          1.0000            1.15850          0.901325       100.742      24.690     0.687886     0.216689     7.51335e-05
  110.0000      252.465          1.0000            1.15767          0.898369       100.742      24.515     0.689644     0.216260     6.57201e-05
  107.5000      251.248          1.0000            1.15672          0.895341       100.742      24.343     0.691392     0.215840     5.73859e-05
  105.0000      249.995          1.0000            1.15566          0.892238       100.742      24.174     0.693128     0.215427     5.00191e-05
  102.5000      248.705          1.0000            1.15447          0.889060       100.742      24.008     0.694854     0.215023     4.35182e-05
  100.0000      247.378          1.0000            1.15316          0.885805       100.742      23.844     0.696568     0.214626     3.77912e-05
   97.5000      246.014          1.0000            1.15172          0.882470       100.742      23.683     0.698272     0.214237     3.27547e-05
   95.0000      244.611          1.0000            1.15014          0.879054       100.742      23.524     0.699965     0.213855     2.83334e-05
   92.5000      243.171          1.0000            1.14843          0.875554       100.742      23.368     0.701648     0.213480     2.44593e-05
   90.0000      241.692          1.0000            1.14657          0.871968       100.742      23.215     0.703320     0.213112     2.10709e-05
   87.5000      240.174          1.0000            1.14456          0.868295       100.742      23.064     0.704981     0.212750     1.81132e-05
   85.0000      238.617          1.0000            1.14240          0.864532       100.742      22.915     0.706632     0.212395     1.55365e-05
   82.5000      237.019          1.0000            1.14008          0.860676       100.742      22.769     0.708273     0.212046     1.32962e-05
   80.0000      235.381          1.0000            1.13760          0.856726       100.742      22.625     0.709903     0.211702     1.13526e-05
   77.5000      233.703          1.0000            1.13495          0.852679       100.742      22.483     0.711523     0.211364     9.66985e-06
   75.0000      231.983          1.0000            1.13213          0.848532       100.742      22.344     0.713133     0.211031     8.21628e-06
   72.5000      230.221          1.0000            1.12912          0.844283       100.742      22.207     0.714733     0.210702     6.96349e-06
   70.0000      228.417          1.0000            1.12593          0.839930       100.742      22.072     0.716324     0.210378     5.88629e-06
   67.5000      226.571          1.0000            1.12255          0.835469       100.742      21.939     0.717904     0.210058     4.96229e-06
   65.0000      224.681          1.0000            1.11897          0.830898       100.742      21.808     0.719475     0.209741     4.17168e-06
   62.5000      222.747          1.0000            1.11518          0.826214       100.742      21.679     0.721035     0.209427     3.49694e-06
   60.0000      220.770          1.0000            1.11118          0.821415       100.742      21.552     0.722586     0.209116     2.92261e-06
   57.5000      218.747          1.0000            1.10697          0.816496       100.742      21.427     0.724128     0.208807     2.43508e-06
   55.0000      216.679          1.0000            1.10252          0.811456       100.742      21.304     0.725660     0.208499     2.02241e-06
   52.5000      214.565          1.0000            1.09785          0.806291       100.742      21.183     0.727183     0.208192     1.67412e-06
   50.0000      212.405          1.0000            1.09293          0.800997       100.742      21.063     0.728696     0.207886     1.38107e-06
   47.5000      210.198          1.0000            1.08776          0.795572       100.742      20.946     0.730200     0.207579     1.13526e-06
   45.0000      207.944          1.0000            1.08233          0.790012       100.742      20.830     0.731695     0.207271     9.29749e-07
   42.5000      205.641          1.0000            1.07664          0.784314       100.742      20.716     0.733181     0.206961     7.58513e-07
   40.0000      203.290          1.0000            1.07067          0.778474       100.742      20.604     0.734658     0.206648     6.16336e-07
   37.5000      200.890          1.0000            1.06442          0.772489       100.742      20.493     0.736126     0.206332     4.98718e-07
   35.0000      198.440          1.0000            1.05787          0.766355       100.742      20.384     0.737584     0.206011     4.01787e-07
   32.5000      195.939          1.0000            1.05102          0.760069       100.742      20.276     0.739035     0.205684     3.22222e-07
   30.0000      193.388          1.0000            1.04385          0.753626       100.742      20.170     0.740476     0.205350     2.57180e-07
   27.5000      190.785          1.0000            1.03636          0.747023       100.742      20.066     0.741908     0.205008     2.04242e-07
   25.0000      188.129          1.0000            1.02853          0.740256       100.742      19.963     0.743332     0.204656     1.61351e-07
   22.5000      185.421          1.0000            1.02035          0.733322       100.742      19.861     0.744748     0.204294     1.26764e-07
   20.0000      182.660          1.0000            1.01181          0.726216       100.742      19.761     0.746155     0.203918     9.90124e-08
   17.5000      179.844          1.0000            1.00290          0.718935       100.742      19.662     0.747553     0.203527     7.68625e-08
   15.0000      176.973          1.0000            0.99361          0.711476       100.742      19.564     0.748944     0.203120     5.92812e-08
   12.5000      174.048          1.0000            0.98392          0.703834       100.742      19.467     0.750326     0.202693     4.54074e-08
   10.0000      171.066          1.0000            0.97382          0.696007       100.742      19.372     0.751700     0.202245     3.45270e-08
    7.5000      168.028          1.0000            0.96330          0.687991       100.742      19.278     0.753065     0.201772     2.60498e-08
    5.0000      164.932          1.0000            0.95233          0.679783       100.742      19.185     0.754423     0.201271     1.94911e-08
    3.8709      163.516          1.0000            0.94723          0.676012       100.742      19.143     0.755034     0.201035     1.70488e-08
END

set output "Figures/Env_003_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:4.5e+02] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_003_LogP_vs_TI_1.pdf"
set xlabel "1/Temperature (1/K)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using (1/($1+273.15)):2 with lines title "Dew Points", \
     $Env_BP using (1/($1+273.15)):2 with lines title "Bubble Points"
unset logscale y

set title "Constant Composition Expansion of Oil Sample 3"
show title

$Expt << END
#           Pres          Rel Vol         Liq Den (kg/m3)      Liq Vis (cp)
#  Stg     (barg)      Expt    Calc        Expt    Calc        Expt    Calc
#------   --------   ----------------   ------------------   ----------------
     1     379.21     0.9761  0.9719      706.80  716.82      0.4760  0.6302
     2     344.74     0.9819  0.9782      702.60  712.18      0.4560  0.5934
     3     310.26     0.9879  0.9852      698.40  707.15      0.4340  0.5563
     4     275.79     0.9943  0.9929      693.90  701.66      0.4130  0.5191
     5     268.90     0.9956  0.9945      692.90  700.51      0.4090  0.5117
     6     262.00     0.9970  0.9962      692.00  699.33      0.4040  0.5042
     7     255.11     0.9983  0.9979      691.10  698.13      0.4000  0.4967
     8     246.83     1.0000  1.0000      689.90  696.65      0.3950  0.4877
     9     236.35     1.0115  1.0114         NaN  701.20         NaN  0.5099
    10     215.94     1.0389  1.0394         NaN  710.54         NaN  0.5593
    11     194.09     1.0777  1.0789         NaN  720.46         NaN  0.6178
    12     170.37     1.1359  1.1379         NaN  731.26         NaN  0.6890
    13     148.10     1.2139  1.2164         NaN  741.50         NaN  0.7651
    14     126.93     1.3210  1.3238         NaN  751.43         NaN  0.8478
    15     108.32     1.4583  1.4605         NaN  760.41         NaN  0.9308
    16      90.32     1.6556  1.6557         NaN  769.41         NaN  1.0230
    17      81.91     1.7821  1.7802         NaN  773.76         NaN  1.0711
END
set xlabel "Pressure (barg)"
set ylabel "Relative Volume"
set output "Figures/Expt_018_RV_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"

set title "Differential Liberation of Oil Sample 3"
show title

$Expt << END
#           Temp       Pres                    Liq Vol (m3)       Removed (sm3)      Liq Den (kg/m3)      Liq Vis (cp)       Gas Z-Factor      Gas Sp Gravity        Gas Vis (cp)
#  Stg       (C)      (barg)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc        Expt    Calc       Expt    Calc       Expt    Calc        Expt      Calc
#------   --------   --------   ----------   ----------------   ----------------   ------------------   ----------------   ----------------   ----------------   --------------------
     1     100.00     379.21       1.00       1.4660  1.4597        NaN    0.00      706.80  716.82      0.4760  0.6302        NaN  1.0483        NaN  1.0708          NaN  0.046911
     2     100.00     344.74       1.00       1.4750  1.4693        NaN    0.00      702.60  712.18      0.4560  0.5934        NaN  0.9884        NaN  0.9787          NaN  0.039440
     3     100.00     310.26       1.00       1.4840  1.4797        NaN    0.00      698.40  707.15      0.4340  0.5563        NaN  0.9426        NaN  0.9109          NaN  0.033870
     4     100.00     275.79       1.00       1.4930  1.4913        NaN    0.00      693.90  701.66      0.4130  0.5191        NaN  0.9078        NaN  0.8586          NaN  0.029309
     5     100.00     268.90       1.00       1.4950  1.4937        NaN    0.00      692.90  700.51      0.4090  0.5117        NaN  0.9020        NaN  0.8497          NaN  0.028482
     6     100.00     262.00       1.00       1.4970  1.4963        NaN    0.00      692.00  699.33      0.4040  0.5042        NaN  0.8966        NaN  0.8411          NaN  0.027679
     7     100.00     255.11       1.00       1.4990  1.4988        NaN    0.00      691.10  698.13      0.4000  0.4967        NaN  0.8916        NaN  0.8330          NaN  0.026900
     8     100.00     246.83       1.00       1.5020  1.5020       0.00    0.00      689.90  696.65      0.3950  0.4877        NaN  0.8861        NaN  0.8237          NaN  0.025995
     9     100.00     220.63       1.00       1.4550  1.4503      18.34   19.44      700.10  708.40      0.4250  0.5476     0.8780  0.8721     0.7920  0.7980     0.022900  0.023334
    10     100.00     193.05       1.00       1.4110  1.3998      35.95   38.49      710.20  721.07      0.4730  0.6218     0.8670  0.8633     0.7650  0.7762     0.020700  0.020867
    11     100.00     165.47       1.00       1.3700  1.3533      52.49   56.02      720.20  733.78      0.5380  0.7077     0.8640  0.8605     0.7490  0.7599     0.019000  0.018756
    12     100.00     137.90       1.00       1.3320  1.3101      68.14   72.30      730.20  746.59      0.6170  0.8076     0.8690  0.8636     0.7430  0.7495     0.017500  0.017007
    13     100.00     110.32       1.00       1.2950  1.2695      83.43   87.54      740.00  759.55      0.7080  0.9242     0.8790  0.8726     0.7510  0.7463     0.016200  0.015605
    14     100.00      82.74       1.00       1.2590  1.2306      98.37  101.94      750.00  772.72      0.8310  1.0609     0.8940  0.8874     0.7720  0.7536     0.015100  0.014509
    15     100.00      55.16       1.00       1.2230  1.1926     112.95  115.79      760.70  786.29      1.0360  1.2233     0.9130  0.9078     0.7930  0.7815     0.014100  0.013640
    16     100.00      27.58       1.00       1.1830  1.1518     128.42  129.88      772.30  801.08      1.4090  1.4285     0.9380  0.9337     0.8870  0.8727     0.012900  0.012809
    17     100.00      11.86       1.00       1.1520  1.1221     138.74  139.16      781.70  811.39      1.7390  1.5924     0.9630  0.9508     1.0470  1.0746     0.012400  0.011998
    18     100.00       0.00       0.00       1.0710  0.9952     157.59  165.60      802.30  841.54      2.0560  2.3041     1.0000  0.9828     1.7690  2.2572     0.009500  0.009604
    19      15.60       0.00       0.50       1.0000  0.9567        NaN  165.60      858.60  875.41         NaN  3.8386        NaN  0.9961        NaN  0.7261          NaN  0.010320
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume (m3)"
set output "Figures/Expt_019_LV_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_019_MR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Phase Density (kg/m3)"
set output "Figures/Expt_019_LDEN_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_019_LVIS_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_019_GZ_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_019_GSG_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:15 with points title "Expt", $Expt using 3:16 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
set output "Figures/Expt_019_GVIS_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"

set title "Separator Test 1 for Oil Sample 3"
show title

$Expt << END
#          Temp       Pres      Tot Vol 2 (m3)      Removed (sm3)      GOR (sm3/m3)      Cum GOR (sm3/m3)      Liq Den (kg/m3)     Gas Sp Gravity         Liq MW           C1N2 y (%)          C2 y (%)           C3 y (%)           C4+ y (%)          C4+ x (%)
# Stg       (C)      (barg)      Expt    Calc       Expt    Calc       Expt    Calc        Expt    Calc         Expt    Calc        Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc
#-----   --------   --------   ----------------   ----------------   ----------------   ------------------   ------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ----------------   ----------------
    1     38.000     40.000     1.0990  1.1038     101.84  101.73     92.660  92.160       92.66   92.16          NaN  814.43      0.6660  0.6699        NaN  164.75     86.510  86.165      6.620   6.934      3.380   3.580      1.660   1.784        NaN  74.932
    2     38.000     12.500     1.0580  1.0626     120.01  118.57     17.180  15.853      113.43  111.58          NaN  830.96      0.7510  0.7753        NaN  186.08     76.070  73.783     11.730  12.583      6.850   7.692      3.090   3.634        NaN  85.615
    3     15.000      0.000     1.0000  1.0072     136.58  132.85     16.570  14.181      136.58  131.91       843.80  855.06      1.1480  1.2480     209.99  207.90     36.410  30.150     23.380  21.922     24.580  28.239     13.350  17.314     94.980  95.556
END
set xlabel "Pressure (barg)"
set ylabel "Volume, After Removal (m3)"
set output "Figures/Expt_020_V2_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:4 with points title "Expt", $Expt using 3:5 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_020_MR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:6 with points title "Expt", $Expt using 3:7 with lines title "Calc"
set ylabel "Instantaneous GOR (sm3/m3)"
set output "Figures/Expt_020_GOR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:8 with points title "Expt", $Expt using 3:9 with lines title "Calc"
set ylabel "Cumulative GOR (sm3/m3)"
set output "Figures/Expt_020_CGOR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:10 with points title "Expt", $Expt using 3:11 with lines title "Calc"
set ylabel "Liquid Phase Density (kg/m3)"
set output "Figures/Expt_020_LDEN_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:12 with points title "Expt", $Expt using 3:13 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_020_GSG_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:14 with points title "Expt", $Expt using 3:15 with lines title "Calc"
set ylabel "Liquid Phase Molecular Weight"
set output "Figures/Expt_020_LMW_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:16 with points title "Expt", $Expt using 3:17 with lines title "Calc"
set xlabel "Pressure (barg)"
set ylabel "Gas C1N2 Mole Fraction (%)"
set output "Figures/Expt_020_Y-C1N2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 3:18 with points title "Expt", $Expt using 3:19 with lines title "Calc"
set ylabel "Gas C2 Mole Fraction (%)"
set output "Figures/Expt_020_Y-C2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 3:20 with points title "Expt", $Expt using 3:21 with lines title "Calc"
set ylabel "Gas C3 Mole Fraction (%)"
set output "Figures/Expt_020_Y-C3_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 3:22 with points title "Expt", $Expt using 3:23 with lines title "Calc"
set ylabel "Gas C4+ Mole Fraction (%)"
set output "Figures/Expt_020_Y-C4+_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 3:24 with points title "Expt", $Expt using 3:25 with lines title "Calc"
set ylabel "Liquid C4+ Mole Fraction (%)"
set output "Figures/Expt_020_X-C4+_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 3:26 with points title "Expt", $Expt using 3:27 with lines title "Calc"

set title "Separator Test 2 for Oil Sample 3"
show title

$Expt << END
#          Temp       Pres      Tot Vol 2 (m3)      Removed (sm3)      GOR (sm3/m3)      Cum GOR (sm3/m3)      Liq Den (kg/m3)     Gas Sp Gravity         Liq MW           C1N2 y (%)          C2 y (%)           C3 y (%)           C4+ y (%)          C4+ x (%)
# Stg       (C)      (barg)      Expt    Calc       Expt    Calc       Expt    Calc        Expt    Calc         Expt    Calc        Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc
#-----   --------   --------   ----------------   ----------------   ----------------   ------------------   ------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ----------------   ----------------
    1     38.000     40.000     1.1020  1.1093     101.54  102.23     92.160  92.160       92.16   92.16          NaN  814.43      0.6640  0.6699        NaN  164.75     86.710  86.165      6.640   6.934      3.380   3.580      1.630   1.784        NaN  74.932
    2     15.000      0.000     1.0000  0.9986     137.33  136.94     35.790  34.758      137.33  137.14       848.10  858.41      0.9500  1.0900     214.79  213.31     55.970  48.242     17.490  15.808     16.150  19.010      8.150  14.818     95.720  96.848
END
set xlabel "Pressure (barg)"
set ylabel "Volume, After Removal (m3)"
set output "Figures/Expt_021_V2_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:4 with points title "Expt", $Expt using 3:5 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_021_MR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:6 with points title "Expt", $Expt using 3:7 with lines title "Calc"
set ylabel "Instantaneous GOR (sm3/m3)"
set output "Figures/Expt_021_GOR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:8 with points title "Expt", $Expt using 3:9 with lines title "Calc"
set ylabel "Cumulative GOR (sm3/m3)"
set output "Figures/Expt_021_CGOR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:10 with points title "Expt", $Expt using 3:11 with lines title "Calc"
set ylabel "Liquid Phase Density (kg/m3)"
set output "Figures/Expt_021_LDEN_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:12 with points title "Expt", $Expt using 3:13 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_021_GSG_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:14 with points title "Expt", $Expt using 3:15 with lines title "Calc"
set ylabel "Liquid Phase Molecular Weight"
set output "Figures/Expt_021_LMW_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:16 with points title "Expt", $Expt using 3:17 with lines title "Calc"
set xlabel "Pressure (barg)"
set ylabel "Gas C1N2 Mole Fraction (%)"
set output "Figures/Expt_021_Y-C1N2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 3:18 with points title "Expt", $Expt using 3:19 with lines title "Calc"
set ylabel "Gas C2 Mole Fraction (%)"
set output "Figures/Expt_021_Y-C2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 3:20 with points title "Expt", $Expt using 3:21 with lines title "Calc"
set ylabel "Gas C3 Mole Fraction (%)"
set output "Figures/Expt_021_Y-C3_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 3:22 with points title "Expt", $Expt using 3:23 with lines title "Calc"
set ylabel "Gas C4+ Mole Fraction (%)"
set output "Figures/Expt_021_Y-C4+_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 3:24 with points title "Expt", $Expt using 3:25 with lines title "Calc"
set ylabel "Liquid C4+ Mole Fraction (%)"
set output "Figures/Expt_021_X-C4+_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 3:26 with points title "Expt", $Expt using 3:27 with lines title "Calc"

set title "Separator Test 3 for Oil Sample 3"
show title

$Expt << END
#          Temp       Pres      Tot Vol 2 (m3)      Removed (sm3)       GOR (sm3/m3)       Cum GOR (sm3/m3)      Liq Den (kg/m3)     Gas Sp Gravity
# Stg       (C)      (barg)      Expt    Calc       Expt    Calc        Expt     Calc        Expt    Calc         Expt    Calc        Expt    Calc
#-----   --------   --------   ----------------   ----------------   ------------------   ------------------   ------------------   ----------------
    1     74.000     9.6800     1.0620  1.0558     140.91  141.64     132.730  134.158      132.73  134.16          NaN  831.92      0.9200  0.8295
    2     74.000     3.2200     1.0520  1.0447     144.78  145.26       3.680    3.462      137.62  139.04          NaN  836.06         NaN  1.1082
    3     15.000     0.0000     1.0000  1.0115     149.12  146.31       4.340    1.034      149.12  144.64       853.40  862.19         NaN  1.0490
END
set xlabel "Pressure (barg)"
set ylabel "Volume, After Removal (m3)"
set output "Figures/Expt_022_V2_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:4 with points title "Expt", $Expt using 3:5 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_022_MR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:6 with points title "Expt", $Expt using 3:7 with lines title "Calc"
set ylabel "Instantaneous GOR (sm3/m3)"
set output "Figures/Expt_022_GOR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:8 with points title "Expt", $Expt using 3:9 with lines title "Calc"
set ylabel "Cumulative GOR (sm3/m3)"
set output "Figures/Expt_022_CGOR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:10 with points title "Expt", $Expt using 3:11 with lines title "Calc"
set ylabel "Liquid Phase Density (kg/m3)"
set output "Figures/Expt_022_LDEN_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:12 with points title "Expt", $Expt using 3:13 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_022_GSG_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:14 with points title "Expt", $Expt using 3:15 with lines title "Calc"

set output
